/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtShapeController.cpp
 *
 *  Created on: Oct 25, 2012
 *      Author: ankele
 */



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/Qt4/QtShapeController.hpp"
#include "Views/Qt4/QtShapeList.hpp"
#include "Menu/Qt4/QtMenuPipe.hpp"

#include <iostream>

#include<Qt/qlayout.h>
#include<Qt/qpushbutton.h>
#include <Qt/qaction.h>

#include "CodePatterns/MemDebug.hpp"

using namespace std;

QtShapeController::QtShapeController(QWidget * _parent) :
    QWidget (_parent)
{
  // Create the widgets.
  QtShapeList *shapeList = new QtShapeList;
  QPushButton *createButton = new QPushButton("create");
  QPushButton *combineButton = new QPushButton("combine");
  QPushButton *deleteButton = new QPushButton("delete");

  // Create layout.
  QVBoxLayout *shapeBox = new QVBoxLayout;
  shapeBox->setMargin(0);
  QHBoxLayout *buttonBox = new QHBoxLayout;
  buttonBox->addWidget(createButton);
  buttonBox->addWidget(combineButton);
  buttonBox->addWidget(deleteButton);
  setLayout(shapeBox);
  shapeBox->addWidget(shapeList);
  shapeBox->addLayout(buttonBox);


  // Create/connect the actions.
  QAction *action = new QAction(QString("create shape"), createButton);
  QtMenuPipe *pipe = new QtMenuPipe("create-shape", action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
  QObject::connect(createButton, SIGNAL(clicked()),action,SIGNAL(triggered()));

  action = new QAction(QString("combine shapes"), combineButton);
  pipe = new QtMenuPipe("combine-shapes", action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
  QObject::connect(combineButton, SIGNAL(clicked()),action,SIGNAL(triggered()));

  action = new QAction(QString("remove shapes"), deleteButton);
  pipe = new QtMenuPipe("remove-shapes", action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
  QObject::connect(deleteButton, SIGNAL(clicked()),action,SIGNAL(triggered()));
}

QtShapeController::~QtShapeController()
{
}
