/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Value_element.cpp
 *
 *  Created on: Sep 10, 2014
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/lexical_cast.hpp>

#include "Value_element.hpp"

#include "CodePatterns/toString.hpp"

#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

static const element * FindElementByString(const std::string &_value)
{
  const element * elem = NULL;
  try {
    const int tempvalue = boost::lexical_cast<atomicNumber_t>(_value);
    elem = World::getInstance().getPeriode()->FindElement(tempvalue);
  } catch( boost::bad_lexical_cast &e) {
    elem = World::getInstance().getPeriode()->FindElement(_value);
  }
  return elem;
}

template <>
bool Value<const element *>::isValidAsString(const std::string &_value) const throw(ParameterValidatorException)
{
  return (FindElementByString(_value) != NULL);
}

template <>
const std::string Value<const element *>::getAsString() const throw(ParameterValueException)
{
  return get()->getName();
}

template <>
void Value<const element *>::setAsString(const std::string &_value) throw(ParameterException)
{
  const element * temp = FindElementByString(_value);
  if (temp != NULL)
    set(temp);
}


