/*
 * GLMoleculeObject.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically meshobject.h.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_HPP_
#define GLMOLECULEOBJECT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtCore/qobject.h>
#include <QtGui/qevent.h>

#include <Qt3D/qglpainter.h>
#include <Qt3D/qglabstractscene.h>

class QGLView;
class QGLSceneNode;
class GLMoleculeScene;

/** This class represents a single object within a molecule, e.g. atom or bond.
 *
 */
class GLMoleculeObject : public QObject
{
   Q_OBJECT

   //!> Allow it to call cleanMaterialMap()
   friend class GLWorldScene;
public:
   explicit GLMoleculeObject(QGLSceneNode *mesh[], QObject *parent=0);
   explicit GLMoleculeObject(QGLSceneNode *mesh, QObject *parent=0);
   explicit GLMoleculeObject(QGLAbstractScene *scene, QObject *parent=0);
   virtual ~GLMoleculeObject();

   QVector3D position() const { return m_position; }
   void setPosition(const QVector3D& value) { m_position = value; }

   void setScale(qreal value) { m_scaleX = m_scaleY = m_scaleZ = value; }

   qreal scaleX() const { return m_scaleX; }
   void setScaleX(qreal value) { m_scaleX = value; }

   qreal scaleY() const { return m_scaleY; }
   void setScaleY(qreal value) { m_scaleY = value; }

   qreal scaleZ() const { return m_scaleZ; }
   void setScaleZ(qreal value) { m_scaleZ = value; }

   qreal rotationAngle() const { return m_rotationAngle; }
   void setRotationAngle(qreal value) { m_rotationAngle = value; }

   QVector3D rotationVector() const { return m_rotationVector; }
   void setRotationVector(const QVector3D& value) { m_rotationVector = value; }

   QGLMaterial *material() const { return m_material; }
   void setMaterial(QGLMaterial *value) { m_material = value; }

   QGLAbstractEffect *effect() const { return m_effect; }
   void setEffect(QGLAbstractEffect *value) { m_effect = value; }

   int objectId() const { return m_objectId; }
   void setObjectId(int id) { m_objectId = id; }

   bool selected() const { return m_selected; }
   void setSelected(bool value);

   void initStaticMaterials();
   void initialize(QGLView *view, QGLPainter *painter);
   virtual void draw(QGLPainter *painter, const QVector4D &cameraPlane);
   void drawSelectionBox(QGLPainter *painter);

signals:
   void pressed();
   void released();
   void clicked();
   void doubleClicked();
   void hoverChanged(GLMoleculeObject *ob);
   void selectionChanged();
   void changed();

protected:
   bool event(QEvent *e);

   static QGLMaterial* getMaterial(size_t);
   static void cleanMaterialMap();

   typedef std::map< size_t, QGLMaterial *> ElementMaterialMap;
   static ElementMaterialMap ElementNoMaterialMap;

public:
   enum{DETAIL_HIGHEST, DETAIL_HIGH, DETAIL_MEDIUM, DETAIL_LOW, DETAILTYPES_MAX} DetailType;

protected:

   static double detailMinDistance[DETAILTYPES_MAX];

   QGLSceneNode *m_mesh[DETAILTYPES_MAX];
   QGLAbstractScene *m_scene;
   QVector3D m_position;
   qreal m_scaleX;
   qreal m_scaleY;
   qreal m_scaleZ;
   qreal m_rotationAngle;
   QVector3D m_rotationVector;
   QGLMaterial *m_material;
   static QGLMaterial *m_hoverMaterial;
   static QGLMaterial *m_selectionMaterial;
   static QGLMaterial *m_selectionBoxMaterial;
   QGLAbstractEffect *m_effect;
   int m_objectId;
   bool m_hovering;
   bool m_selected;
};


#endif /* GLMOLECULEOBJECT_HPP_ */
