/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ObserverBoxStub.cpp
 *
 *  Created on: Dec 22, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Box.hpp"

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Notification.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"


Box::Box(RealSpaceMatrix _M) :
  Observable("Box"),
  M( new RealSpaceMatrix(_M) ),
  Minv( new RealSpaceMatrix )
{
  // observable stuff
  Channels *OurChannel = new Channels;
  NotificationChannels.insert( std::make_pair(this, OurChannel) );
  // add instance for each notification type
  OurChannel->addChannel(Box::MatrixChanged);
  *Minv = M->invert();

  conditions.resize(3);
  conditions[0] = conditions[1] = conditions[2] = Wrap;
}

Box::~Box()
{
  // observable stuff
  std::map<Observable *, Channels*>::iterator iter = NotificationChannels.find(this);
  delete iter->second;
  NotificationChannels.erase(iter);

  delete M;
  delete Minv;
}

const RealSpaceMatrix &Box::getMinv() const
{
  return *Minv;
}

const Box::Conditions_t Box::getConditions() const
{
  return conditions;
}

