/*
 * Plane.hpp
 *
 *  Created on: Apr 7, 2010
 *      Author: crueger
 */

#ifndef PLANE_HPP_
#define PLANE_HPP_

#include <memory>
#include <vector>
#include <iosfwd>
#include "Space.hpp"
#include "Exceptions/LinearDependenceException.hpp"
#include "Exceptions/ZeroVectorException.hpp"

class Vector;
class Line;

class Plane : public Space
{
  friend bool operator==(const Plane&,const Plane&);
  typedef std::auto_ptr<Vector> vec_ptr;
public:
  Plane(const Vector &y1, const Vector &y2, const Vector &y3) throw(LinearDependenceException);
  Plane(const Vector &y1, const Vector &y2, double _offset) throw(ZeroVectorException,LinearDependenceException);
  Plane(const Vector &_normalVector, double _offset)  throw(ZeroVectorException);
  Plane(const Vector &_normalVector, const Vector &_offsetVector) throw(ZeroVectorException);
  Plane(const Plane& plane);
  virtual ~Plane();

  Plane &operator=(const Plane&);

  // Accessor Functions
  /**
   * returns normal Vector for a plane
   */
  Vector getNormal() const;
  /**
   * returns the distance of the plane from the origin
   */
  double getOffset() const;
  /**
   * returns a vector that points on the plane.
   * Same as getOffset()*getNormal();
   */
  Vector getOffsetVector() const;

  /**
   * returns three seperate points on this plane
   */
  std::vector<Vector> getPointsOnPlane() const;

  // some calculations
  Vector GetIntersection(const Line &Line) const;

  Vector mirrorVector(const Vector &rhs) const;

  /**
   * get a Line that is orthogonal to this plane, going through a chosen
   * point.
   *
   * The point does not have to lie on the plane itself.
   */
  Line getOrthogonalLine(const Vector &origin) const;

  /**
   * Test if two points are on the same side of the plane
   */
  bool onSameSide(const Vector&,const Vector&) const;

  /****** Methods inherited from Space ***********/

  virtual double distance(const Vector &point) const;
  virtual Vector getClosestPoint(const Vector &point) const;

private:
  vec_ptr normalVector;
  double offset;
};

bool operator==(const Plane&,const Plane&);

std::ostream &operator<< (std::ostream &ost,const Plane& p);

#endif /* PLANE_HPP_ */
