/*
 * LineSegmentSet.hpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

#ifndef LINESEGMENTSET_HPP_
#define LINESEGMENTSET_HPP_

#include <memory>
#include <set>

class Vector;
class Line;
class LineSegment;

class LineSegmentSet {
  friend LineSegmentSet merge(const LineSegmentSet&,const LineSegmentSet&);
  friend LineSegmentSet intersect(const LineSegmentSet&, const LineSegmentSet&);
  friend LineSegmentSet invert(const LineSegmentSet &);

  typedef std::set<LineSegment> set_t;
  typedef std::auto_ptr<Line> lineptr;
public:
  typedef set_t::iterator iterator;
  typedef set_t::const_iterator const_iterator;

  LineSegmentSet(const Line&);
  LineSegmentSet(const LineSegmentSet&);
  LineSegmentSet& operator=(const LineSegmentSet&);

  void insert(const LineSegment&);
  void erase(const LineSegment&);

  iterator       begin();
  const_iterator begin() const;
  iterator       end();
  const_iterator end()   const;

  bool isContained(const Vector &) const;
  Line getLine();
private:
  lineptr line;
  set_t segments;
};

LineSegmentSet merge(const LineSegmentSet&,const LineSegmentSet&);
LineSegmentSet intersect(const LineSegmentSet&, const LineSegmentSet&);
LineSegmentSet invert(const LineSegmentSet &);

#endif /* LINESEGMENTSET_HPP_ */
