/*
 * LineSegment.hpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

#ifndef LINESEGMENT_HPP_
#define LINESEGMENT_HPP_

#include <memory>

class Vector;
class Line;
class LinePoint;

class LineSegment
{
  friend bool operator==(const LineSegment&,const LineSegment&);
  friend bool operator<(const LineSegment&,const LineSegment&);

  typedef std::auto_ptr<LinePoint> pointptr;
  typedef std::auto_ptr<Line> lineptr;
public:
  LineSegment(const Vector&,const Vector&);
  LineSegment(const LinePoint&,const LinePoint&);
  LineSegment(const LineSegment&);
  virtual ~LineSegment();
  LineSegment &operator=(const LineSegment&);

  bool isContained(const Vector &) const;
  bool isContained(const LinePoint &) const;
  bool overlaps(const LineSegment&) const;
  bool hasZeroLength() const;
  LinePoint getBegin() const;
  LinePoint getEnd() const;
  Line getLine() const;

private:
  pointptr begin;
  pointptr end;
  lineptr line;
};

bool operator==(const LineSegment&,const LineSegment&);
bool operator<(const LineSegment&,const LineSegment&);

#endif /* LINESEGMENT_HPP_ */
