/*
 * AtomShapeDescriptor.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

#include "AtomShapeDescriptor.hpp"
#include "AtomShapeDescriptor_impl.hpp"

#include "atom.hpp"

AtomShapeDescriptor_impl::AtomShapeDescriptor_impl(const Shape &_shape) :
  shape(_shape)
{}

AtomShapeDescriptor_impl::~AtomShapeDescriptor_impl(){}

bool AtomShapeDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom){
  return shape.isInside(*atom.second->node);
}


AtomDescriptor AtomByShape(const Shape &shape){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomShapeDescriptor_impl(shape)));
}
