/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringsQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>
#include <Qt/qlistwidget.h>
#include <Qt/qpushbutton.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/QtQueryListPipe.hpp"


QtDialog::StringsQtQuery::StringsQtQuery(Parameter<std::vector<std::string> > &param, std::string _title,QBoxLayout *_parent,QtDialog *_dialog) :
    Dialog::StringsQuery(param, _title),
    parent(_parent)
{
  QHBoxLayout * thisHLayout = new QHBoxLayout();
  QVBoxLayout * thisV1Layout = new QVBoxLayout();
  QVBoxLayout * thisV2Layout = new QVBoxLayout();

  QLabel *titleLabel = new QLabel(QString(getTitle().c_str()));
  QLabel *inputLabel = new QLabel("Enter to add");
  QListWidget* inputList = new QListWidget();
  inputList->setSelectionMode(QAbstractItemView::ExtendedSelection);
  QLineEdit* inputBox = new QLineEdit();
  inputLabel->setBuddy(inputBox);
  titleLabel->setBuddy(inputList);
  QPushButton* AddButton = new QPushButton("Add");
  AddButton->setEnabled(false);
  QPushButton* RemoveButton = new QPushButton("Remove");
  RemoveButton->setEnabled(false);

  thisV1Layout->addWidget(titleLabel);
  thisV1Layout->addWidget(inputList);
  thisV2Layout->addWidget(inputLabel);
  thisV2Layout->addWidget(inputBox);
  thisV2Layout->addWidget(AddButton);
  thisV2Layout->addWidget(RemoveButton);
  parent->addLayout(thisHLayout);
  thisHLayout->addLayout(thisV1Layout);
  thisHLayout->addLayout(thisV2Layout);

  pipe = new StringsQtQueryPipe(tmp,_dialog,inputBox,inputList,AddButton,RemoveButton);
  connect(inputBox,SIGNAL(textChanged(const QString&)),pipe,SLOT(elementEntered(const QString&)));
  connect(inputList,SIGNAL(itemSelectionChanged()),pipe,SLOT(elementSelected()));
  connect(AddButton,SIGNAL(clicked()),pipe,SLOT(addElement()));
  connect(RemoveButton,SIGNAL(clicked()),pipe,SLOT(removeElement()));}

QtDialog::StringsQtQuery::~StringsQtQuery()
{
  delete pipe;
}

// All values besides the empty std::string are valid
bool QtDialog::StringsQtQuery::handle()
{
/*  // dissect by ","
  std::string::iterator olditer = temp.begin();
  std::vector<std::string> temp_strings;
  for(std::string::iterator iter = temp.begin(); iter != temp.end(); ++iter) {
    if (*iter == ' ') {
      temp_strings.push_back(std::string(iter, olditer));
      olditer = iter;
    }
  }
  if (olditer != temp.begin())  // insert last part also
    temp_strings.push_back(std::string(olditer, temp.end()));
  tmp.set(temp_strings);

  return temp!="";*/
  return true;
}

