/*
 * QtQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef QTQUERY_HPP_
#define QTQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Qt4/QtDialog.hpp"
#include "Parameters/Parameter.hpp"

class QHBoxLayout;
class QBoxLayout;
class QDialogButtonBox;
class QLabel;
class QSpinBox;
class QDoubleSpinBox;
class QLineEdit;
class QListWidget;
class QPushButton;
class QTableWidget;
class QTextEdit;
class QComboBox;
class QCheckBox;

// Forward declarations for plumbing
template<typename T> class QtQueryListPipe;
class AtomQtQueryPipe;
class AtomsQtQueryPipe;
class BooleanQtQueryPipe;
class RealSpaceMatrixQtQueryPipe;
class DoubleQtQueryPipe;
class DoublesQtQueryPipe;
class ElementQtQueryPipe;
class ElementsQtQueryPipe;
class EmptyQtQueryPipe;
class FileQtQueryPipe;
class FilesQtQueryPipe;
class IntQtQueryPipe;
class MoleculeQtQueryPipe;
class MoleculesQtQueryPipe;
class StringQtQueryPipe;
class StringsQtQueryPipe;
class UnsignedIntQtQueryPipe;
class UnsignedIntsQtQueryPipe;
class VectorQtQueryPipe;
class VectorsQtQueryPipe;
class RandomNumberDistribution_ParametersQtQueryPipe;

class QtDialog::AtomQtQuery : public Dialog::AtomQuery {
public:
  AtomQtQuery(Parameter<const atom *> &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~AtomQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;

  AtomQtQueryPipe *pipe;
};

class QtDialog::AtomsQtQuery : public Dialog::AtomsQuery {
public:
  AtomsQtQuery(Parameter<std::vector<const atom *> > &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~AtomsQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLabel *inputLabel;
  QListWidget *inputList;

  AtomsQtQueryPipe *pipe;
};

class QtDialog::BooleanQtQuery : public Dialog::BooleanQuery {
public:
  BooleanQtQuery(Parameter<bool> &, std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
  virtual ~BooleanQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QCheckBox *booleanCheckBox;

  BooleanQtQueryPipe *pipe;
};

class QtDialog::RealSpaceMatrixQtQuery : public Dialog::RealSpaceMatrixQuery {
public:
  RealSpaceMatrixQtQuery(Parameter<RealSpaceMatrix> &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~RealSpaceMatrixQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QTableWidget *inputTable;

  RealSpaceMatrixQtQueryPipe *pipe;
};

class QtDialog::DoubleQtQuery : public Dialog::DoubleQuery {
public:
  DoubleQtQuery(Parameter<double> &, std::string title,QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~DoubleQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QDoubleSpinBox *inputBox;

  DoubleQtQueryPipe *pipe;
};

class QtDialog::DoublesQtQuery : public Dialog::DoublesQuery {
public:
  DoublesQtQuery(Parameter<std::vector<double> > &, std::string title,QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~DoublesQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QDoubleSpinBox *inputBox;

  QtQueryListPipe<double> *pipe;
};

class QtDialog::ElementQtQuery : public Dialog::ElementQuery {
public:
  ElementQtQuery(Parameter<const element *> &, std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
  virtual ~ElementQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;

  ElementQtQueryPipe *pipe;
};

class QtDialog::ElementsQtQuery : public Dialog::ElementsQuery {
public:
  ElementsQtQuery(Parameter<std::vector<const element *> > &, std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
  virtual ~ElementsQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;

  ElementsQtQueryPipe *pipe;
};

class QtDialog::EmptyQtQuery : public Dialog::EmptyQuery {
public:
  EmptyQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
  virtual ~EmptyQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;

  EmptyQtQueryPipe *pipe;
};

class QtDialog::FileQtQuery : public Dialog::FileQuery {
public:
  FileQtQuery(Parameter<boost::filesystem::path> &, std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
  virtual ~FileQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *filenameLabel;
  QLineEdit *filenameLineEdit;
  QPushButton *filedialogButton;

  FileQtQueryPipe *pipe;
};

class QtDialog::FilesQtQuery : public Dialog::FilesQuery {
public:
  FilesQtQuery(Parameter<std::vector< boost::filesystem::path> > &param, std::string _title, QBoxLayout *_parent, QtDialog *_dialog);
  virtual ~FilesQtQuery();
  virtual bool handle();
  void IntegerEntered(const QString&);
  void IntegerSelected();
  void AddInteger();
  void RemoveInteger();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;

  QtQueryListPipe<boost::filesystem::path> *pipe;
};

class QtDialog::IntQtQuery : public Dialog::IntQuery {
public:
  IntQtQuery(Parameter<int> &, std::string _title,QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~IntQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QSpinBox *inputBox;

  IntQtQueryPipe *pipe;
};

class QtDialog::IntsQtQuery : public Dialog::IntsQuery {
public:
  IntsQtQuery(Parameter<std::vector<int> > &, std::string _title,QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~IntsQtQuery();
  virtual bool handle();
  void IntegerEntered(const QString&);
  void IntegerSelected();
  void AddInteger();
  void RemoveInteger();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;

  QtQueryListPipe<int> *pipe;
};

class QtDialog::MoleculeQtQuery : public Dialog::MoleculeQuery {
public:
  MoleculeQtQuery(Parameter<const molecule *> &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~MoleculeQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;

  MoleculeQtQueryPipe *pipe;
};

class QtDialog::MoleculesQtQuery : public Dialog::MoleculesQuery {
public:
  MoleculesQtQuery(Parameter<std::vector<const molecule *> > &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~MoleculesQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;

  MoleculesQtQueryPipe *pipe;
};

class QtDialog::StringQtQuery : public Dialog::StringQuery {
public:
  StringQtQuery(Parameter<std::string> &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~StringQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLineEdit *inputBox;

  StringQtQueryPipe *pipe;
};

class QtDialog::StringsQtQuery : public Dialog::StringsQuery {
public:
  StringsQtQuery(Parameter<std::vector<std::string> > &, std::string _title, QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~StringsQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLineEdit *inputBox;

  StringsQtQueryPipe *pipe;
};

class QtDialog::UnsignedIntQtQuery : public Dialog::UnsignedIntQuery {
public:
  UnsignedIntQtQuery(Parameter<unsigned int> &, std::string _title,QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~UnsignedIntQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QSpinBox *inputBox;

  UnsignedIntQtQueryPipe *pipe;
};

class QtDialog::UnsignedIntsQtQuery : public Dialog::UnsignedIntsQuery {
public:
  UnsignedIntsQtQuery(Parameter<std::vector<unsigned int> > &, std::string _title,QBoxLayout *_parent,QtDialog *_dialog);
  virtual ~UnsignedIntsQtQuery();
  virtual bool handle();
  void IntegerEntered(const QString&);
  void IntegerSelected();
  void AddInteger();
  void RemoveInteger();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;

  QtQueryListPipe<unsigned int> *pipe;
};


class QtDialog::VectorQtQuery : public Dialog::VectorQuery {
public:
  VectorQtQuery(Parameter<Vector> &, std::string title,bool _check,QBoxLayout *,QtDialog *);
  virtual ~VectorQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *mainLayout;
  QLabel *titleLabel;
  QBoxLayout *subLayout;
  QBoxLayout *coordLayout;
  QLabel *coordLabel;
  QDoubleSpinBox *coordInputX;
  QDoubleSpinBox *coordInputY;
  QDoubleSpinBox *coordInputZ;

  VectorQtQueryPipe *pipe;
};

class QtDialog::VectorsQtQuery : public Dialog::VectorsQuery {
public:
  VectorsQtQuery(Parameter<std::vector<Vector> > &, std::string title,bool _check,QBoxLayout *,QtDialog *);
  virtual ~VectorsQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *mainLayout;
  QLabel *titleLabel;
  QBoxLayout *subLayout;
  QBoxLayout *coordLayout;
  QLabel *coordLabel;
  QDoubleSpinBox *coordInput;

  VectorsQtQueryPipe *pipe;
};

class QtDialog::RandomNumberDistribution_ParametersQtQuery : public Dialog::RandomNumberDistribution_ParametersQuery {
public:
  RandomNumberDistribution_ParametersQtQuery(Parameter<RandomNumberDistribution_Parameters> &, std::string title,QBoxLayout *,QtDialog *);
  virtual ~RandomNumberDistribution_ParametersQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QHBoxLayout *thisLayout;
  QLabel *titleLabel;
  QTextEdit *inputBox;
  QPushButton *okButton;

  RandomNumberDistribution_ParametersQtQueryPipe *pipe;
};

#endif /* QTQUERY_HPP_ */
