/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ActionNameValidator.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ActionNameValidator.hpp"

#include "Actions/ActionRegistry.hpp"

bool ActionNameValidator::isValid(const std::string & _value) const
{
  if (MoleCuilder::ActionRegistry::getCompletely_instatiated())
    return MoleCuilder::ActionRegistry::getInstance().isActionPresentByName(_value);
  else
    return false;
}

bool ActionNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const ActionNameValidator *inst =
      dynamic_cast<const ActionNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* ActionNameValidator::clone() const
{
  Validator< std::string > *inst =
      new ActionNameValidator();
  return inst;
}




