/*
 * Registry<Action>.hpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#ifndef ACTIONREGISTRY_HPP_
#define ACTIONREGISTRY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <iosfwd>
#include <string>
#include <map>

#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"
#include "Actions/Action.hpp"

namespace MoleCuilder {

/** Action Registry.
 *
 * The Action registry is a storage for any Action instance to retrieved by name.
 * It is a singleton and can be called from anywhere.
 *
 * ActionRegistry::fillRegistry() is the essential function, called in the cstor,
 * where all the prototypical Action's are instantiated. To this end, we sadly
 * require a global list of all present actions (\note there is a regression test
 * check on its completeness). We include \ref GlobalListOfActionsh.hpp where a
 * boost::preprocessor sequence is contained that is then used to install each
 * of the Action's in the registry.
 *
 */
class ActionRegistry : public Singleton<ActionRegistry>, public Registry<Action>
{
  friend class Singleton<ActionRegistry>;
  //friend class Registry<Action>;

public:
  Action* getActionByName(const std::string name);
  bool isActionPresentByName(const std::string name) const;
  int getLastPosition(const std::string &MenuName) const;

  /** Static getter for the state of the registry.
   *
   * @return true - ActionRegistry's cstor has run through, false - else
   */
  static bool getCompletely_instatiated()
  { return completely_instatiated; }

private:
  ActionRegistry();
  ~ActionRegistry();

  void fillRegistry();

  //!> this tells whether ActionRegistry has been completed instantiated.
  static bool completely_instatiated;
};

}

#endif /* ACTIONREGISTRY_HPP_ */
