/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Registry<Action>.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/ActionRegistry.hpp"
#include "CodePatterns/Singleton_impl.hpp"
#include "CodePatterns/Registry_impl.hpp"

#include "GlobalListOfActions.hpp"

#include "AllActionHeaders.hpp"

#include <boost/preprocessor/iteration/local.hpp>
#include <boost/preprocessor/seq/elem.hpp>
#include <boost/preprocessor/seq/size.hpp>

using namespace MoleCuilder;

// static entities
bool ActionRegistry::completely_instatiated = false;

/** Constructor for class ActionRegistry.
 */
ActionRegistry::ActionRegistry()
{
  //std::cout << "ActionRegistry::ActionRegistry() called, instance is " << this << "." << std::endl;
  fillRegistry();
  completely_instatiated = true;
}

/** Destructor for class ActionRegistry.
 */
ActionRegistry::~ActionRegistry()
{
  //std::cout << "ActionRegistry::~ActionRegistry() called, instance is " << this << "." << std::endl;
  cleanup();
}


/** Instantiates each existing Action.
 *
 */
void ActionRegistry::fillRegistry()
{
#define instance_print(z,n,list) \
	{ \
	Action * presentAction = new \
	BOOST_PP_CAT(BOOST_PP_SEQ_ELEM(n, list), Action) \
	(); \
	registerInstance(presentAction); \
	}
#define BOOST_PP_LOCAL_MACRO(n) instance_print(~, n, GLOBALLISTOFACTIONS)
#define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_DEC(BOOST_PP_SEQ_SIZE(GLOBALLISTOFACTIONS)))
#include BOOST_PP_LOCAL_ITERATE()
#undef instance_print  
}

/** Just passes on call to Registry<Action>::getByName().
 * \param name name of Action
 * \return pointer to Action
 */
Action* ActionRegistry::getActionByName(const std::string name)
{
  return getByName(name);
}

/** Just passes on call to Registry<Action>::isPresentByName().
 * \param name name of Action
 * \return true - Action instance present, false - not
 */
bool ActionRegistry::isActionPresentByName(const std::string name) const
{
  return isPresentByName(name);
}

/** Returns the last present action position in the requested menu.
 * \param &token token of the menu
 * \return last used position
 */
int ActionRegistry::getLastPosition(const std::string &token) const
{
  int position = 0;
  for (const_iterator iter = getBeginIter();
      iter != getEndIter();
      ++iter) {
    const std::string &MenuName = (iter->second)->Traits.getMenuName();
    const int &MenuPosition = (iter->second)->Traits.getMenuPosition();
    if ((MenuName == token) && (position < MenuPosition))
      position = MenuPosition;
  }
  return position;
}


CONSTRUCT_SINGLETON(ActionRegistry)
CONSTRUCT_REGISTRY(Action)
