/*
 * MoleculeUnitTest.hpp
 *
 *  Created on: Mar 19, 2012
 *      Author: heber
 */

#ifndef MOLECULEUNITTEST_HPP_
#define MOLECULEUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

class atom;
class molecule;

class MoleculeUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( MoleculeUnittest );
  CPPUNIT_TEST ( getBoundingShapeTest_linearchain );
  CPPUNIT_TEST ( getBoundingShapeTest_vshaped );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void getBoundingShapeTest_linearchain();
  void getBoundingShapeTest_vshaped();

private:
  std::vector<atom *> atomVector;
  molecule *mol;

  static size_t MaxAtoms;
};

#endif /* MOLECULEUNITTEST_HPP_ */
