/*
 * AtomIdSetUnitTest.hpp
 *
 *  Created on: Feb 21, 2012
 *      Author: heber
 */

#ifndef ATOMIDSETUNITTEST_HPP_
#define ATOMIDSETUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

class atom;

#include "AtomIdSet.hpp"

class AtomIdSetUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( AtomIdSetUnittest );
  CPPUNIT_TEST ( inserteraseTest );
  CPPUNIT_TEST ( positionTest );
  CPPUNIT_TEST ( findTest );
  CPPUNIT_TEST ( emptyTest );
  CPPUNIT_TEST ( sizeTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void inserteraseTest();
  void positionTest();
  void findTest();
  void emptyTest();
  void sizeTest();

private:
  std::vector<atom *> atomVector;
  AtomIdSet atoms;

  static size_t MaxAtoms;
};

#endif /* ATOMIDSETUNITTEST_HPP_ */
