/*
 * ApproximateShapeArea.hpp
 *
 *  Created on: Jan 30, 2012
 *      Author: heber
 */

#ifndef APPROXIMATESHAPEAREA_HPP_
#define APPROXIMATESHAPEAREA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Shapes/Shape.hpp"

/** Functor for the approximate surface are of a shape.
 *
 * This class is just an intermediate until we have implemented a better way
 * to calculate the surface area within the constructuve solid geometry method.
 */
class ApproximateShapeArea
{
public:
	ApproximateShapeArea(const Shape &_shape);
	~ApproximateShapeArea();

	double operator()() const;

private:
	Shape shape;
};


#endif /* APPROXIMATESHAPEAREA_HPP_ */
