/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Shape_HomogeneousPointsUnitTest.cpp
 *
 *  Created on: Jun 19, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cmath>
#include <limits>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include "CodePatterns/Assert.hpp"

#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"

#include "Shape_HomogeneousPointsUnitTest.hpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( Shape_HomogeneousPointsTest );

void Shape_HomogeneousPointsTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);
}

void Shape_HomogeneousPointsTest::tearDown()
{}

/** Unit test for points on Shape's surface.
 *
 */
void Shape_HomogeneousPointsTest::surfaceTest()
{
	CPPUNIT_ASSERT(true);
}

/** Unit test for points in Shape's volume.
 *
 */
void Shape_HomogeneousPointsTest::volumeTest()
{
	CPPUNIT_ASSERT(true);
}
