/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BaseShapesUnitTest.cpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cmath>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include "CodePatterns/Assert.hpp"

#include "Helpers/defs.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"

#include "BaseShapesUnitTest.hpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( BaseShapesTest );

void BaseShapesTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  v000 =  0*unitVec[0]+0*unitVec[1]+0*unitVec[2];
  v100 =  1*unitVec[0]+0*unitVec[1]+0*unitVec[2];
  v200 = -1*unitVec[0]+0*unitVec[1]+0*unitVec[2];
  v010 =  0*unitVec[0]+1*unitVec[1]+0*unitVec[2];
  v110 =  1*unitVec[0]+1*unitVec[1]+0*unitVec[2];
  v210 = -1*unitVec[0]+1*unitVec[1]+0*unitVec[2];
  v020 =  0*unitVec[0]-1*unitVec[1]+0*unitVec[2];
  v120 =  1*unitVec[0]-1*unitVec[1]+0*unitVec[2];
  v220 = -1*unitVec[0]-1*unitVec[1]+0*unitVec[2];
  v001 =  0*unitVec[0]+0*unitVec[1]+1*unitVec[2];
  v101 =  1*unitVec[0]+0*unitVec[1]+1*unitVec[2];
  v201 = -1*unitVec[0]+0*unitVec[1]+1*unitVec[2];
  v011 =  0*unitVec[0]+1*unitVec[1]+1*unitVec[2];
  v111 =  1*unitVec[0]+1*unitVec[1]+1*unitVec[2];
  v211 = -1*unitVec[0]+1*unitVec[1]+1*unitVec[2];
  v021 =  0*unitVec[0]-1*unitVec[1]+1*unitVec[2];
  v121 =  1*unitVec[0]-1*unitVec[1]+1*unitVec[2];
  v221 = -1*unitVec[0]-1*unitVec[1]+1*unitVec[2];
  v002 =  0*unitVec[0]+0*unitVec[1]-1*unitVec[2];
  v102 =  1*unitVec[0]+0*unitVec[1]-1*unitVec[2];
  v202 = -1*unitVec[0]+0*unitVec[1]-1*unitVec[2];
  v012 =  0*unitVec[0]+1*unitVec[1]-1*unitVec[2];
  v112 =  1*unitVec[0]+1*unitVec[1]-1*unitVec[2];
  v212 = -1*unitVec[0]+1*unitVec[1]-1*unitVec[2];
  v022 =  0*unitVec[0]-1*unitVec[1]-1*unitVec[2];
  v122 =  1*unitVec[0]-1*unitVec[1]-1*unitVec[2];
  v222 = -1*unitVec[0]-1*unitVec[1]-1*unitVec[2];
}

void BaseShapesTest::tearDown()
{}


void BaseShapesTest::baseShapesTest(){
  CPPUNIT_ASSERT(!Nowhere().isInside(v000));
  CPPUNIT_ASSERT(!Nowhere().isInside(v100));
  CPPUNIT_ASSERT(!Nowhere().isInside(v200));
  CPPUNIT_ASSERT(!Nowhere().isInside(v010));
  CPPUNIT_ASSERT(!Nowhere().isInside(v110));
  CPPUNIT_ASSERT(!Nowhere().isInside(v210));
  CPPUNIT_ASSERT(!Nowhere().isInside(v020));
  CPPUNIT_ASSERT(!Nowhere().isInside(v120));
  CPPUNIT_ASSERT(!Nowhere().isInside(v220));
  CPPUNIT_ASSERT(!Nowhere().isInside(v001));
  CPPUNIT_ASSERT(!Nowhere().isInside(v101));
  CPPUNIT_ASSERT(!Nowhere().isInside(v201));
  CPPUNIT_ASSERT(!Nowhere().isInside(v011));
  CPPUNIT_ASSERT(!Nowhere().isInside(v111));
  CPPUNIT_ASSERT(!Nowhere().isInside(v211));
  CPPUNIT_ASSERT(!Nowhere().isInside(v021));
  CPPUNIT_ASSERT(!Nowhere().isInside(v121));
  CPPUNIT_ASSERT(!Nowhere().isInside(v221));
  CPPUNIT_ASSERT(!Nowhere().isInside(v002));
  CPPUNIT_ASSERT(!Nowhere().isInside(v102));
  CPPUNIT_ASSERT(!Nowhere().isInside(v202));
  CPPUNIT_ASSERT(!Nowhere().isInside(v012));
  CPPUNIT_ASSERT(!Nowhere().isInside(v112));
  CPPUNIT_ASSERT(!Nowhere().isInside(v212));
  CPPUNIT_ASSERT(!Nowhere().isInside(v022));
  CPPUNIT_ASSERT(!Nowhere().isInside(v122));
  CPPUNIT_ASSERT(!Nowhere().isInside(v222));

  CPPUNIT_ASSERT(Everywhere().isInside(v000));
  CPPUNIT_ASSERT(Everywhere().isInside(v100));
  CPPUNIT_ASSERT(Everywhere().isInside(v200));
  CPPUNIT_ASSERT(Everywhere().isInside(v010));
  CPPUNIT_ASSERT(Everywhere().isInside(v110));
  CPPUNIT_ASSERT(Everywhere().isInside(v210));
  CPPUNIT_ASSERT(Everywhere().isInside(v020));
  CPPUNIT_ASSERT(Everywhere().isInside(v120));
  CPPUNIT_ASSERT(Everywhere().isInside(v220));
  CPPUNIT_ASSERT(Everywhere().isInside(v001));
  CPPUNIT_ASSERT(Everywhere().isInside(v101));
  CPPUNIT_ASSERT(Everywhere().isInside(v201));
  CPPUNIT_ASSERT(Everywhere().isInside(v011));
  CPPUNIT_ASSERT(Everywhere().isInside(v111));
  CPPUNIT_ASSERT(Everywhere().isInside(v211));
  CPPUNIT_ASSERT(Everywhere().isInside(v021));
  CPPUNIT_ASSERT(Everywhere().isInside(v121));
  CPPUNIT_ASSERT(Everywhere().isInside(v221));
  CPPUNIT_ASSERT(Everywhere().isInside(v002));
  CPPUNIT_ASSERT(Everywhere().isInside(v102));
  CPPUNIT_ASSERT(Everywhere().isInside(v202));
  CPPUNIT_ASSERT(Everywhere().isInside(v012));
  CPPUNIT_ASSERT(Everywhere().isInside(v112));
  CPPUNIT_ASSERT(Everywhere().isInside(v212));
  CPPUNIT_ASSERT(Everywhere().isInside(v022));
  CPPUNIT_ASSERT(Everywhere().isInside(v122));
  CPPUNIT_ASSERT(Everywhere().isInside(v222));

  Shape s1 = Sphere();

  CPPUNIT_ASSERT(s1.isInside(v000));
  CPPUNIT_ASSERT(s1.isInside(v100));
  CPPUNIT_ASSERT(s1.isInside(v200));
  CPPUNIT_ASSERT(s1.isInside(v010));
  CPPUNIT_ASSERT(!s1.isInside(v110));
  CPPUNIT_ASSERT(!s1.isInside(v210));
  CPPUNIT_ASSERT(s1.isInside(v020));
  CPPUNIT_ASSERT(!s1.isInside(v120));
  CPPUNIT_ASSERT(!s1.isInside(v220));
  CPPUNIT_ASSERT(s1.isInside(v001));
  CPPUNIT_ASSERT(!s1.isInside(v101));
  CPPUNIT_ASSERT(!s1.isInside(v201));
  CPPUNIT_ASSERT(!s1.isInside(v011));
  CPPUNIT_ASSERT(!s1.isInside(v111));
  CPPUNIT_ASSERT(!s1.isInside(v211));
  CPPUNIT_ASSERT(!s1.isInside(v021));
  CPPUNIT_ASSERT(!s1.isInside(v121));
  CPPUNIT_ASSERT(!s1.isInside(v221));
  CPPUNIT_ASSERT(s1.isInside(v002));
  CPPUNIT_ASSERT(!s1.isInside(v102));
  CPPUNIT_ASSERT(!s1.isInside(v202));
  CPPUNIT_ASSERT(!s1.isInside(v012));
  CPPUNIT_ASSERT(!s1.isInside(v112));
  CPPUNIT_ASSERT(!s1.isInside(v212));
  CPPUNIT_ASSERT(!s1.isInside(v022));
  CPPUNIT_ASSERT(!s1.isInside(v122));
  CPPUNIT_ASSERT(!s1.isInside(v222));

  Shape s2 = Cuboid();

  CPPUNIT_ASSERT(s2.isInside(v000));
  CPPUNIT_ASSERT(s2.isInside(v100));
  CPPUNIT_ASSERT(!s2.isInside(v200));
  CPPUNIT_ASSERT(s2.isInside(v010));
  CPPUNIT_ASSERT(s2.isInside(v110));
  CPPUNIT_ASSERT(!s2.isInside(v210));
  CPPUNIT_ASSERT(!s2.isInside(v020));
  CPPUNIT_ASSERT(!s2.isInside(v120));
  CPPUNIT_ASSERT(!s2.isInside(v220));
  CPPUNIT_ASSERT(s2.isInside(v001));
  CPPUNIT_ASSERT(s2.isInside(v101));
  CPPUNIT_ASSERT(!s2.isInside(v201));
  CPPUNIT_ASSERT(s2.isInside(v011));
  CPPUNIT_ASSERT(s2.isInside(v111));
  CPPUNIT_ASSERT(!s2.isInside(v211));
  CPPUNIT_ASSERT(!s2.isInside(v021));
  CPPUNIT_ASSERT(!s2.isInside(v121));
  CPPUNIT_ASSERT(!s2.isInside(v221));
  CPPUNIT_ASSERT(!s2.isInside(v002));
  CPPUNIT_ASSERT(!s2.isInside(v102));
  CPPUNIT_ASSERT(!s2.isInside(v202));
  CPPUNIT_ASSERT(!s2.isInside(v012));
  CPPUNIT_ASSERT(!s2.isInside(v112));
  CPPUNIT_ASSERT(!s2.isInside(v212));
  CPPUNIT_ASSERT(!s2.isInside(v022));
  CPPUNIT_ASSERT(!s2.isInside(v122));
  CPPUNIT_ASSERT(!s2.isInside(v222));
}

void BaseShapesTest::surfaceTest(){
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v000));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v100));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v200));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v010));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v110));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v210));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v020));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v120));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v220));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v001));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v101));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v201));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v011));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v111));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v211));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v021));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v121));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v221));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v002));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v102));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v202));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v012));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v112));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v212));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v022));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v122));
  CPPUNIT_ASSERT(!Nowhere().isOnSurface(v222));

  CPPUNIT_ASSERT(Cuboid().isOnSurface(v000));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v100));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v200));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v010));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v110));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v210));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v020));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v120));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v220));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v001));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v101));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v201));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v011));
  CPPUNIT_ASSERT(Cuboid().isOnSurface(v111));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v211));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v021));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v121));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v221));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v002));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v102));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v202));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v012));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v112));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v212));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v022));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v122));
  CPPUNIT_ASSERT(!Cuboid().isOnSurface(v222));

  CPPUNIT_ASSERT(!Sphere().isOnSurface(v000));
  CPPUNIT_ASSERT(Sphere().isOnSurface(v100));
  CPPUNIT_ASSERT(Sphere().isOnSurface(v200));
  CPPUNIT_ASSERT(Sphere().isOnSurface(v010));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v110));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v210));
  CPPUNIT_ASSERT(Sphere().isOnSurface(v020));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v120));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v220));
  CPPUNIT_ASSERT(Sphere().isOnSurface(v001));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v101));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v201));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v011));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v111));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v211));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v021));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v121));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v221));
  CPPUNIT_ASSERT(Sphere().isOnSurface(v002));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v102));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v202));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v012));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v112));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v212));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v022));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v122));
  CPPUNIT_ASSERT(!Sphere().isOnSurface(v222));
}

void BaseShapesTest::assignmentTest(){
  Shape s1 = Nowhere();
  s1 = Everywhere();

  CPPUNIT_ASSERT(s1.isInside(v000));
  CPPUNIT_ASSERT(s1.isInside(v100));
  CPPUNIT_ASSERT(s1.isInside(v200));
  CPPUNIT_ASSERT(s1.isInside(v010));
  CPPUNIT_ASSERT(s1.isInside(v110));
  CPPUNIT_ASSERT(s1.isInside(v210));
  CPPUNIT_ASSERT(s1.isInside(v020));
  CPPUNIT_ASSERT(s1.isInside(v120));
  CPPUNIT_ASSERT(s1.isInside(v220));
  CPPUNIT_ASSERT(s1.isInside(v001));
  CPPUNIT_ASSERT(s1.isInside(v101));
  CPPUNIT_ASSERT(s1.isInside(v201));
  CPPUNIT_ASSERT(s1.isInside(v011));
  CPPUNIT_ASSERT(s1.isInside(v111));
  CPPUNIT_ASSERT(s1.isInside(v211));
  CPPUNIT_ASSERT(s1.isInside(v021));
  CPPUNIT_ASSERT(s1.isInside(v121));
  CPPUNIT_ASSERT(s1.isInside(v221));
  CPPUNIT_ASSERT(s1.isInside(v002));
  CPPUNIT_ASSERT(s1.isInside(v102));
  CPPUNIT_ASSERT(s1.isInside(v202));
  CPPUNIT_ASSERT(s1.isInside(v012));
  CPPUNIT_ASSERT(s1.isInside(v112));
  CPPUNIT_ASSERT(s1.isInside(v212));
  CPPUNIT_ASSERT(s1.isInside(v022));
  CPPUNIT_ASSERT(s1.isInside(v122));
  CPPUNIT_ASSERT(s1.isInside(v222));

  Shape s2 = Everywhere();
  s2 = Nowhere();

  CPPUNIT_ASSERT(!s2.isInside(v000));
  CPPUNIT_ASSERT(!s2.isInside(v100));
  CPPUNIT_ASSERT(!s2.isInside(v200));
  CPPUNIT_ASSERT(!s2.isInside(v010));
  CPPUNIT_ASSERT(!s2.isInside(v110));
  CPPUNIT_ASSERT(!s2.isInside(v210));
  CPPUNIT_ASSERT(!s2.isInside(v020));
  CPPUNIT_ASSERT(!s2.isInside(v120));
  CPPUNIT_ASSERT(!s2.isInside(v220));
  CPPUNIT_ASSERT(!s2.isInside(v001));
  CPPUNIT_ASSERT(!s2.isInside(v101));
  CPPUNIT_ASSERT(!s2.isInside(v201));
  CPPUNIT_ASSERT(!s2.isInside(v011));
  CPPUNIT_ASSERT(!s2.isInside(v111));
  CPPUNIT_ASSERT(!s2.isInside(v211));
  CPPUNIT_ASSERT(!s2.isInside(v021));
  CPPUNIT_ASSERT(!s2.isInside(v121));
  CPPUNIT_ASSERT(!s2.isInside(v221));
  CPPUNIT_ASSERT(!s2.isInside(v002));
  CPPUNIT_ASSERT(!s2.isInside(v102));
  CPPUNIT_ASSERT(!s2.isInside(v202));
  CPPUNIT_ASSERT(!s2.isInside(v012));
  CPPUNIT_ASSERT(!s2.isInside(v112));
  CPPUNIT_ASSERT(!s2.isInside(v212));
  CPPUNIT_ASSERT(!s2.isInside(v022));
  CPPUNIT_ASSERT(!s2.isInside(v122));
  CPPUNIT_ASSERT(!s2.isInside(v222));

}

void BaseShapesTest::operatorTest(){
  {
    Shape s1 = !Nowhere();
    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(s1.isInside(v110));
    CPPUNIT_ASSERT(s1.isInside(v210));
    CPPUNIT_ASSERT(s1.isInside(v020));
    CPPUNIT_ASSERT(s1.isInside(v120));
    CPPUNIT_ASSERT(s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(s1.isInside(v101));
    CPPUNIT_ASSERT(s1.isInside(v201));
    CPPUNIT_ASSERT(s1.isInside(v011));
    CPPUNIT_ASSERT(s1.isInside(v111));
    CPPUNIT_ASSERT(s1.isInside(v211));
    CPPUNIT_ASSERT(s1.isInside(v021));
    CPPUNIT_ASSERT(s1.isInside(v121));
    CPPUNIT_ASSERT(s1.isInside(v221));
    CPPUNIT_ASSERT(s1.isInside(v002));
    CPPUNIT_ASSERT(s1.isInside(v102));
    CPPUNIT_ASSERT(s1.isInside(v202));
    CPPUNIT_ASSERT(s1.isInside(v012));
    CPPUNIT_ASSERT(s1.isInside(v112));
    CPPUNIT_ASSERT(s1.isInside(v212));
    CPPUNIT_ASSERT(s1.isInside(v022));
    CPPUNIT_ASSERT(s1.isInside(v122));
    CPPUNIT_ASSERT(s1.isInside(v222));

    Shape s2 = !Everywhere();
    CPPUNIT_ASSERT(!s2.isInside(v000));
    CPPUNIT_ASSERT(!s2.isInside(v100));
    CPPUNIT_ASSERT(!s2.isInside(v200));
    CPPUNIT_ASSERT(!s2.isInside(v010));
    CPPUNIT_ASSERT(!s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(!s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(!s2.isInside(v001));
    CPPUNIT_ASSERT(!s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(!s2.isInside(v011));
    CPPUNIT_ASSERT(!s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(!s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));
  }

  {
    Shape s1 = Nowhere() || Everywhere();
    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(s1.isInside(v110));
    CPPUNIT_ASSERT(s1.isInside(v210));
    CPPUNIT_ASSERT(s1.isInside(v020));
    CPPUNIT_ASSERT(s1.isInside(v120));
    CPPUNIT_ASSERT(s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(s1.isInside(v101));
    CPPUNIT_ASSERT(s1.isInside(v201));
    CPPUNIT_ASSERT(s1.isInside(v011));
    CPPUNIT_ASSERT(s1.isInside(v111));
    CPPUNIT_ASSERT(s1.isInside(v211));
    CPPUNIT_ASSERT(s1.isInside(v021));
    CPPUNIT_ASSERT(s1.isInside(v121));
    CPPUNIT_ASSERT(s1.isInside(v221));
    CPPUNIT_ASSERT(s1.isInside(v002));
    CPPUNIT_ASSERT(s1.isInside(v102));
    CPPUNIT_ASSERT(s1.isInside(v202));
    CPPUNIT_ASSERT(s1.isInside(v012));
    CPPUNIT_ASSERT(s1.isInside(v112));
    CPPUNIT_ASSERT(s1.isInside(v212));
    CPPUNIT_ASSERT(s1.isInside(v022));
    CPPUNIT_ASSERT(s1.isInside(v122));
    CPPUNIT_ASSERT(s1.isInside(v222));

    Shape s2 = Nowhere() && Everywhere();
    CPPUNIT_ASSERT(!s2.isInside(v000));
    CPPUNIT_ASSERT(!s2.isInside(v100));
    CPPUNIT_ASSERT(!s2.isInside(v200));
    CPPUNIT_ASSERT(!s2.isInside(v010));
    CPPUNIT_ASSERT(!s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(!s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(!s2.isInside(v001));
    CPPUNIT_ASSERT(!s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(!s2.isInside(v011));
    CPPUNIT_ASSERT(!s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(!s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));
  }

  {
    Shape s1 = Everywhere() || Nowhere();
    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(s1.isInside(v110));
    CPPUNIT_ASSERT(s1.isInside(v210));
    CPPUNIT_ASSERT(s1.isInside(v020));
    CPPUNIT_ASSERT(s1.isInside(v120));
    CPPUNIT_ASSERT(s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(s1.isInside(v101));
    CPPUNIT_ASSERT(s1.isInside(v201));
    CPPUNIT_ASSERT(s1.isInside(v011));
    CPPUNIT_ASSERT(s1.isInside(v111));
    CPPUNIT_ASSERT(s1.isInside(v211));
    CPPUNIT_ASSERT(s1.isInside(v021));
    CPPUNIT_ASSERT(s1.isInside(v121));
    CPPUNIT_ASSERT(s1.isInside(v221));
    CPPUNIT_ASSERT(s1.isInside(v002));
    CPPUNIT_ASSERT(s1.isInside(v102));
    CPPUNIT_ASSERT(s1.isInside(v202));
    CPPUNIT_ASSERT(s1.isInside(v012));
    CPPUNIT_ASSERT(s1.isInside(v112));
    CPPUNIT_ASSERT(s1.isInside(v212));
    CPPUNIT_ASSERT(s1.isInside(v022));
    CPPUNIT_ASSERT(s1.isInside(v122));
    CPPUNIT_ASSERT(s1.isInside(v222));

    Shape s2 = Everywhere() && Nowhere();
    CPPUNIT_ASSERT(!s2.isInside(v000));
    CPPUNIT_ASSERT(!s2.isInside(v100));
    CPPUNIT_ASSERT(!s2.isInside(v200));
    CPPUNIT_ASSERT(!s2.isInside(v010));
    CPPUNIT_ASSERT(!s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(!s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(!s2.isInside(v001));
    CPPUNIT_ASSERT(!s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(!s2.isInside(v011));
    CPPUNIT_ASSERT(!s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(!s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));
  }

  {
    Shape s1 = Sphere() && Cuboid(); // Sphere in upper place

    CPPUNIT_ASSERT(s1.isInside(v000));
    CPPUNIT_ASSERT(s1.isInside(v100));
    CPPUNIT_ASSERT(!s1.isInside(v200));
    CPPUNIT_ASSERT(s1.isInside(v010));
    CPPUNIT_ASSERT(!s1.isInside(v110));
    CPPUNIT_ASSERT(!s1.isInside(v210));
    CPPUNIT_ASSERT(!s1.isInside(v020));
    CPPUNIT_ASSERT(!s1.isInside(v120));
    CPPUNIT_ASSERT(!s1.isInside(v220));
    CPPUNIT_ASSERT(s1.isInside(v001));
    CPPUNIT_ASSERT(!s1.isInside(v101));
    CPPUNIT_ASSERT(!s1.isInside(v201));
    CPPUNIT_ASSERT(!s1.isInside(v011));
    CPPUNIT_ASSERT(!s1.isInside(v111));
    CPPUNIT_ASSERT(!s1.isInside(v211));
    CPPUNIT_ASSERT(!s1.isInside(v021));
    CPPUNIT_ASSERT(!s1.isInside(v121));
    CPPUNIT_ASSERT(!s1.isInside(v221));
    CPPUNIT_ASSERT(!s1.isInside(v002));
    CPPUNIT_ASSERT(!s1.isInside(v102));
    CPPUNIT_ASSERT(!s1.isInside(v202));
    CPPUNIT_ASSERT(!s1.isInside(v012));
    CPPUNIT_ASSERT(!s1.isInside(v112));
    CPPUNIT_ASSERT(!s1.isInside(v212));
    CPPUNIT_ASSERT(!s1.isInside(v022));
    CPPUNIT_ASSERT(!s1.isInside(v122));
    CPPUNIT_ASSERT(!s1.isInside(v222));

    CPPUNIT_ASSERT(s1.isOnSurface(v000));
    CPPUNIT_ASSERT(s1.isOnSurface(v100));
    CPPUNIT_ASSERT(!s1.isOnSurface(v200));
    CPPUNIT_ASSERT(s1.isOnSurface(v010));
    CPPUNIT_ASSERT(!s1.isOnSurface(v110));
    CPPUNIT_ASSERT(!s1.isOnSurface(v210));
    CPPUNIT_ASSERT(!s1.isOnSurface(v020));
    CPPUNIT_ASSERT(!s1.isOnSurface(v120));
    CPPUNIT_ASSERT(!s1.isOnSurface(v220));
    CPPUNIT_ASSERT(s1.isOnSurface(v001));
    CPPUNIT_ASSERT(!s1.isOnSurface(v101));
    CPPUNIT_ASSERT(!s1.isOnSurface(v201));
    CPPUNIT_ASSERT(!s1.isOnSurface(v011));
    CPPUNIT_ASSERT(!s1.isOnSurface(v111));
    CPPUNIT_ASSERT(!s1.isOnSurface(v211));
    CPPUNIT_ASSERT(!s1.isOnSurface(v021));
    CPPUNIT_ASSERT(!s1.isOnSurface(v121));
    CPPUNIT_ASSERT(!s1.isOnSurface(v221));
    CPPUNIT_ASSERT(!s1.isOnSurface(v002));
    CPPUNIT_ASSERT(!s1.isOnSurface(v102));
    CPPUNIT_ASSERT(!s1.isOnSurface(v202));
    CPPUNIT_ASSERT(!s1.isOnSurface(v012));
    CPPUNIT_ASSERT(!s1.isOnSurface(v112));
    CPPUNIT_ASSERT(!s1.isOnSurface(v212));
    CPPUNIT_ASSERT(!s1.isOnSurface(v022));
    CPPUNIT_ASSERT(!s1.isOnSurface(v122));
    CPPUNIT_ASSERT(!s1.isOnSurface(v222));


    Shape s2 = Sphere() || Cuboid(); // Should be same as Cuboid

    CPPUNIT_ASSERT(s2.isInside(v000));
    CPPUNIT_ASSERT(s2.isInside(v100));
    CPPUNIT_ASSERT(s2.isInside(v200));
    CPPUNIT_ASSERT(s2.isInside(v010));
    CPPUNIT_ASSERT(s2.isInside(v110));
    CPPUNIT_ASSERT(!s2.isInside(v210));
    CPPUNIT_ASSERT(s2.isInside(v020));
    CPPUNIT_ASSERT(!s2.isInside(v120));
    CPPUNIT_ASSERT(!s2.isInside(v220));
    CPPUNIT_ASSERT(s2.isInside(v001));
    CPPUNIT_ASSERT(s2.isInside(v101));
    CPPUNIT_ASSERT(!s2.isInside(v201));
    CPPUNIT_ASSERT(s2.isInside(v011));
    CPPUNIT_ASSERT(s2.isInside(v111));
    CPPUNIT_ASSERT(!s2.isInside(v211));
    CPPUNIT_ASSERT(!s2.isInside(v021));
    CPPUNIT_ASSERT(!s2.isInside(v121));
    CPPUNIT_ASSERT(!s2.isInside(v221));
    CPPUNIT_ASSERT(s2.isInside(v002));
    CPPUNIT_ASSERT(!s2.isInside(v102));
    CPPUNIT_ASSERT(!s2.isInside(v202));
    CPPUNIT_ASSERT(!s2.isInside(v012));
    CPPUNIT_ASSERT(!s2.isInside(v112));
    CPPUNIT_ASSERT(!s2.isInside(v212));
    CPPUNIT_ASSERT(!s2.isInside(v022));
    CPPUNIT_ASSERT(!s2.isInside(v122));
    CPPUNIT_ASSERT(!s2.isInside(v222));

    CPPUNIT_ASSERT(!s2.isOnSurface(v000));
    CPPUNIT_ASSERT(s2.isOnSurface(v100));
    CPPUNIT_ASSERT(s2.isOnSurface(v200));
    CPPUNIT_ASSERT(s2.isOnSurface(v010));
    CPPUNIT_ASSERT(s2.isOnSurface(v110));
    CPPUNIT_ASSERT(!s2.isOnSurface(v210));
    CPPUNIT_ASSERT(s2.isOnSurface(v020));
    CPPUNIT_ASSERT(!s2.isOnSurface(v120));
    CPPUNIT_ASSERT(!s2.isOnSurface(v220));
    CPPUNIT_ASSERT(s2.isOnSurface(v001));
    CPPUNIT_ASSERT(s2.isOnSurface(v101));
    CPPUNIT_ASSERT(!s2.isOnSurface(v201));
    CPPUNIT_ASSERT(s2.isOnSurface(v011));
    CPPUNIT_ASSERT(s2.isOnSurface(v111));
    CPPUNIT_ASSERT(!s2.isOnSurface(v211));
    CPPUNIT_ASSERT(!s2.isOnSurface(v021));
    CPPUNIT_ASSERT(!s2.isOnSurface(v121));
    CPPUNIT_ASSERT(!s2.isOnSurface(v221));
    CPPUNIT_ASSERT(s2.isOnSurface(v002));
    CPPUNIT_ASSERT(!s2.isOnSurface(v102));
    CPPUNIT_ASSERT(!s2.isOnSurface(v202));
    CPPUNIT_ASSERT(!s2.isOnSurface(v012));
    CPPUNIT_ASSERT(!s2.isOnSurface(v112));
    CPPUNIT_ASSERT(!s2.isOnSurface(v212));
    CPPUNIT_ASSERT(!s2.isOnSurface(v022));
    CPPUNIT_ASSERT(!s2.isOnSurface(v122));
    CPPUNIT_ASSERT(!s2.isOnSurface(v222));
  }

}

void BaseShapesTest::PointsOnSurfaceTest(){
  Shape s = Sphere();
  const size_t N = 200;
  std::vector<Vector> PointsOnSurface = s.getHomogeneousPointsOnSurface(N);
  for (std::vector<Vector>::const_iterator iter = PointsOnSurface.begin(); iter != PointsOnSurface.end(); ++iter) {
    CPPUNIT_ASSERT(fabs(1. - (*iter).NormSquared()) < MYEPSILON);
  }
  CPPUNIT_ASSERT_EQUAL((size_t)194, PointsOnSurface.size());
}
