/*
 * ClusterUnitTest.hpp
 *
 *  Created on: Jan 17, 2012
 *      Author: heber
 */

#ifndef CLUSTERUNITTEST_HPP_
#define CLUSTERUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "types.hpp"

class atom;
class Cluster;
class Shape;

/********************************************** Test classes **************************************/

class ClusterTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( ClusterTest) ;
    CPPUNIT_TEST ( insert_eraseTest );
    CPPUNIT_TEST ( setter_getterTest );
    CPPUNIT_TEST ( IsInShapeTest );
    CPPUNIT_TEST ( getAtomRefsTest );
    CPPUNIT_TEST ( translateTest );
    CPPUNIT_TEST ( transformTest );
    CPPUNIT_TEST ( cloneTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void insert_eraseTest();
      void setter_getterTest();
      void IsInShapeTest();
      void getAtomRefsTest();
      void translateTest();
      void transformTest();
      void cloneTest();

private:
      Cluster *cluster;
      Shape *shape;
      atom * _atom;
      atomId_t _atomId;
};

#endif /* CLUSTERUNITTEST_HPP_ */
