/*
 * Ops_FillPredicate_impl.hpp
 *
 *  Created on: 17.01.2012
 *      Author: heber
 */

#ifndef OPS_FILLPREDICATE_IMPL_HPP_
#define OPS_FILLPREDICATE_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FillPredicateBase.hpp"

/** Logical AND composition of two FillPredicate's.
 *
 */
class And_FillPredicate : public FillPredicateBase
{
public:
	And_FillPredicate(const FillPredicate::impl_ptr &_a, const FillPredicate::impl_ptr &_b) :
		a(_a), b(_b)
	{}
	virtual ~And_FillPredicate()
	{}

	bool operator()(const Node &n) const {
		return (*a)(n) && (*b)(n);
	}

private:
	FillPredicate::impl_ptr a;
	FillPredicate::impl_ptr b;
};

/** Logical OR composition of two FillPredicate's.
 *
 */
class Or_FillPredicate : public FillPredicateBase
{
public:
	Or_FillPredicate(const FillPredicate::impl_ptr &_a, const FillPredicate::impl_ptr &_b) :
		a(_a), b(_b)
	{}
	virtual ~Or_FillPredicate()
	{}

	bool operator()(const Node &n) const {
		return (*a)(n) || (*b)(n);
	}

private:
	FillPredicate::impl_ptr a;
	FillPredicate::impl_ptr b;
};

/** Logical NOT composition of two FillPredicate's.
 *
 */
class Not_FillPredicate : public FillPredicateBase
{
public:
	Not_FillPredicate(const FillPredicate::impl_ptr &_a) :
		a(_a)
	{}
	virtual ~Not_FillPredicate()
	{}

	bool operator()(const Node &n) const {
		return !(*a)(n);
	}

private:
	FillPredicate::impl_ptr a;
};

#endif /* OPS_FILLPREDICATE_IMPL_HPP_ */
