/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IsValidInDomain_FillPredicate.cpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>

#include "IsValidInDomain_FillPredicate.hpp"

#include "AnyFillPredicate.hpp"
#include "Box.hpp"
#include "FillPredicate.hpp"


FillPredicate IsValidInDomain_FillPredicate(const Box &domain)
{
  AnyFillPredicate::FillPredicator function = boost::bind(&Box::isValid, &domain, _1);
  FillPredicate::impl_ptr impl(new AnyFillPredicate(function));
  return FillPredicate(impl);
}
