/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IsInsideSurface_FillPredicate.cpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>

#include "IsInsideSurface_FillPredicate.hpp"

#include "AnyFillPredicate.hpp"
#include "FillPredicate.hpp"
#include "Tesselation/tesselation.hpp"

FillPredicate IsInsideSurface_FillPredicate(const Tesselation &_tess, const LinkedCell_deprecated &_LC)
{
  AnyFillPredicate::FillPredicator function = boost::bind(&Tesselation::IsInnerPoint, &_tess, _1, &_LC);
  FillPredicate::impl_ptr impl(new AnyFillPredicate(function));
  return FillPredicate(impl);
}
