/*
 * FillPredicate.hpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */

#ifndef FILLPREDICATE_HPP_
#define FILLPREDICATE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Filling/NodeTypes.hpp"

#include <boost/shared_ptr.hpp>

class FillPredicateBase;

/** This class defines the interface for all derived classes.
 *
 * This is just a functor of a predicate function.
 *
 */
class FillPredicate
{
public:
  typedef boost::shared_ptr<FillPredicateBase> impl_ptr;
  friend impl_ptr getFillPredicateImpl(const FillPredicate&);

  FillPredicate(const FillPredicate &ptr);
  FillPredicate(impl_ptr);
  ~FillPredicate();
  bool operator()(const Node &n) const;

protected:
  impl_ptr getImpl() const;

private:
  impl_ptr impl;
};

FillPredicate AlwaysFillPredicate();
FillPredicate NeverFillPredicate();

FillPredicate::impl_ptr getFillPredicateImpl(const FillPredicate &f);

#endif /* FILLPREDICATE_HPP_ */
