/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FillPredicate.cpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "FillPredicate.hpp"

#include "FillPredicateBase.hpp"
#include "FillPredicate_impl.hpp"

/** Constructor for class FillPredicate.
 *
 * @param _impl implementation to wrap
 */
FillPredicate::FillPredicate(FillPredicate::impl_ptr _impl) :
    impl(_impl)
{}

/** Copy Constructor for class FillPredicate.
 *
 */
FillPredicate::FillPredicate(const FillPredicate &ptr) :
    impl(ptr.getImpl())
{}

/** Destructor for class FillPredicate.
 *
 */
FillPredicate::~FillPredicate()
{}

bool FillPredicate::operator()(const Node &n) const
{
  return impl->operator()(n);
}

FillPredicate::impl_ptr FillPredicate::getImpl() const {
  return impl;
}

FillPredicate AlwaysFillPredicate()
{
  static FillPredicate::impl_ptr impl = FillPredicate::impl_ptr(new AlwaysFillPredicate_impl());
  return FillPredicate(impl);
}

FillPredicate NeverFillPredicate()
{
  static FillPredicate::impl_ptr impl = FillPredicate::impl_ptr(new NeverFillPredicate_impl());
  return FillPredicate(impl);
}

// allows arbitrary friendship, but only if implementation is known
FillPredicate::impl_ptr getFillPredicateImpl(const FillPredicate &f){
  return f.getImpl();
}
