/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AnyFillPredicate.cpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "AnyFillPredicate.hpp"

/** Constructor for class AnyFillPredicate.
 *
 * @param _function function to use as predicate
 */
AnyFillPredicate::AnyFillPredicate(FillPredicator &_function) :
  function(_function)
{}

/** Destructor for class AnyFillPredicate
 *
 */
AnyFillPredicate::~AnyFillPredicate()
{}

/** Predicate implementation that simply calls upon \a AnyFillPredicate::function.
 *
 * @param n Node for which the predicate is to check
 * @return true - predicate results as true, false - predicate results as false
 */
bool AnyFillPredicate::operator()(const Node&n) const {
  return function(n);
}
