/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Mesh.cpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Mesh.hpp"

#include "CodePatterns/Assert.hpp"

/** Constructor for class Mesh.
 *
 */
Mesh::Mesh()
{}

/** Copy constructor for class Mesh.
 *
 * @param mesh instance to copy
 */
Mesh::Mesh(const Mesh &mesh) :
    nodes(mesh.getNodes())
{
  ASSERT( nodes.size() == mesh.getNodes().size(),
      "Mesh::Mesh() - copied nodes contains not the same number.");
}

/** Destructor for class Mesh.
 *
 */
Mesh::~Mesh()
{}

const NodeSet & Mesh::getNodes() const
{
  return nodes;
}
