/*
 * NodeGenerator.hpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */

#ifndef NODEGENERATOR_HPP_
#define NODEGENERATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Filling/NodeTypes.hpp"

#include "Shapes/Shape.hpp"

/** The class NodeGenerator is an interface to routines that generate points
 * within a domain used for subsequent traversal and test as possible filling
 * positions.
 *
 */
class NodeGenerator
{
public:

  NodeGenerator(const Shape &_shape);
  ~NodeGenerator();

  NodeSet operator()(const double density);

private:
  NodeSet filterOutsidePoints(const NodeSet &nodes) const;

  Shape shape;
};


#endif /* NODEGENERATOR_HPP_ */
