/*
 * Filler.hpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */

#ifndef FILLER_HPP_
#define FILLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Cluster.hpp"
#include "Predicates/FillPredicate.hpp"
#include "Mesh/Mesh.hpp"
#include "NodeTypes.hpp"

class CopyAtomsInterface;
class FillPredicate;
class Inserter;
class Mesh;

/** This class operators on a set of nodes (Vector's), checks which fulfill some
 * given predicate, and fills these position with a given molecule lateron.
 *
 */
class Filler
{
public:
  Filler(const Mesh &_mesh, const FillPredicate &_predicate, const Inserter &_inserter);
  ~Filler();

  bool operator()(CopyAtomsInterface &copyMethod, ClusterInterface::Cluster_impl cluster) const;

private:
  //!> mesh is the set of points filling a Shape
  const Mesh mesh;
  //!> the predicate is evaluted whether a Node in the NodeSet of mesh is filled or not
  const FillPredicate predicate;
  //!> Inserter function to allow for some changes when placing the cluster at the node
  const Inserter &inserter;
};


#endif /* FILLER_HPP_ */
