/*
 * Cluster.hpp
 *
 *  Created on: Jan 16, 2012
 *      Author: heber
 */

#ifndef CLUSTER_HPP_
#define CLUSTER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.hpp"

#include <set>

#include "ClusterInterface.hpp"

#include "Atom/CopyAtoms/CopyAtomsInterface.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/Shape.hpp"

class atom;
class RealSpaceMatrix;

/** A Cluster is a set of atoms within a given Shape that contains them.
 *
 */
class Cluster : public ClusterInterface
{
  //!> grant unit test access
  friend class ClusterTest;
public:
  typedef std::set<atomId_t> atomIdSet;
  typedef std::vector<atom *> AtomVector;

  Cluster(const Cluster & _cluster);
  Cluster(const Shape &s);
  Cluster(const atomIdSet &atoms, const Shape &s);
  ~Cluster();

  void insert(const atomId_t id);
  void erase(const atomId_t id);

  /** Getter for the internal set of atomic ids.
   *
   * @return atomIdSet with \a atoms
   */
  const atomIdSet & getAtomIds() const { return atoms; }

  Cluster_impl clone(CopyAtomsInterface& copyMethod, const Vector &offset = zeroVec) const;

  void translate(const Vector &offset);

  void transform(const RealSpaceMatrix &M);

  bool isInside(const atomId_t id) const {
    return IsInShape(id);
  }

  /** Getter for the internal Shape.
   *
   * @return Shape \a s
   */
  const Shape& getShape() const { return s; }

private:
  /** Getter for the contained atoms.
   *
   * @return vector of atomic refs
   */
  AtomVector getAtomRefs() const;

  //!> do not allow Cluster without Shape
  Cluster();

  bool IsInShape(const atomId_t id) const;
  atom * const getAtomById(const atomId_t id) const;

  atomIdSet atoms;
  Shape s;
};


#endif /* CLUSTER_HPP_ */
