/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomShapeDescriptor.cpp
 *
 *  Created on: Jul 22, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "AtomShapeDescriptor.hpp"
#include "AtomShapeDescriptor_impl.hpp"

#include "Atom/atom.hpp"

AtomShapeDescriptor_impl::AtomShapeDescriptor_impl(const Shape &_shape) :
  shape(_shape)
{}

AtomShapeDescriptor_impl::~AtomShapeDescriptor_impl(){}

bool AtomShapeDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom){
  return shape.isInside(atom.second->getPosition());
}

atom* AtomShapeDescriptor_impl::find(){
  LinkedCell::LinkedCell_View view = World::getInstance().getLinkedCell(shape.getRadius());
  LinkedCell::LinkedList list = view.getPointsInsideSphere(shape.getRadius(), shape.getCenter());
  for (LinkedCell::LinkedList::iterator iter = list.begin(); iter != list.end(); ++iter) {
    atom * const _atom = static_cast<atom *>(const_cast<TesselPoint *>(*iter));
    if (shape.isInside(_atom->getPosition()))
      return _atom;
  }
  return NULL;
}

std::vector<atom*> AtomShapeDescriptor_impl::findAll(){
  LinkedCell::LinkedCell_View view = World::getInstance().getLinkedCell(shape.getRadius());
  LinkedCell::LinkedList list = view.getPointsInsideSphere(shape.getRadius(), shape.getCenter());
  std::vector<atom*> res;
  for (LinkedCell::LinkedList::iterator iter = list.begin(); iter != list.end(); ++iter) {
    atom * const _atom = static_cast<atom *>(const_cast<TesselPoint *>(*iter));
    if (shape.isInside(_atom->getPosition()))
      res.push_back(_atom);
  }
  return res;
}


AtomDescriptor AtomsByShape(const Shape &shape){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomShapeDescriptor_impl(shape)));
}
