/*
 * AtomIdSet.hpp
 *
 *  Created on: Feb 21, 2012
 *      Author: heber
 */

#ifndef ATOMIDSET_HPP_
#define ATOMIDSET_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/iterator/transform_iterator.hpp>

#include <set>
#include <vector>

#include "types.hpp"

class atom;
struct FromIdToAtom :
  public std::unary_function<atom *, atomId_t>
{
    atom * operator()(atomId_t id) const;
};

/** AtomIdSet is a set of atomic ids that however behave as a set of atoms.
 *
 * This class represents an iterable set of atoms that is however only stored as
 * ids internally.
 */
class AtomIdSet
{
public:
  typedef std::set<atomId_t> atomIdSet;
  typedef boost::transform_iterator<FromIdToAtom, atomIdSet::iterator, atom *, atomId_t> iterator;
  typedef boost::transform_iterator<FromIdToAtom, atomIdSet::const_iterator, const atom *, atomId_t const &> const_iterator;

  AtomIdSet(const atomIdSet &_atoms);
  AtomIdSet(const std::vector<atom *> &_atoms);
  AtomIdSet();
  ~AtomIdSet();

  iterator begin();
  const_iterator begin() const;
  iterator end();
  const_iterator end() const;
  bool empty() const;
  size_t size() const;
  const_iterator find(const atom * const key) const;
  const_iterator find(const atomId_t &id) const;
  std::pair<iterator, bool> insert(const atom * const key);
  std::pair<iterator, bool> insert(const atomId_t &id);
  const_iterator erase(const_iterator &loc);
  const_iterator erase(const atom * const key);
  const_iterator erase(const atomId_t &id);

  /** Getter for internal set of atoms.
   *
   * @return set of atomic ids
   */
  const atomIdSet & getAtomIds() const {
    return atoms;
  }

private:
  //!> internal atoms stored by their ids
  atomIdSet atoms;
};


#endif /* ATOMIDSET_HPP_ */
