/*
 * CopyAtomsInterfaceUnitTest.hpp
 *
 *  Created on: Mar 17, 2012
 *      Author: heber
 */

#ifndef COPYATOMSINTERFACEUNITTEST_HPP_
#define COPYATOMSINTERFACEUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "types.hpp"

// we prefer enum over define
enum { ATOM_COUNT = 2 };

class atom;

class CopyAtomsInterfaceTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( CopyAtomsInterfaceTest );
  CPPUNIT_TEST ( CopyAtomsInterfaceOperatorTest );
  CPPUNIT_TEST ( CopyAtoms_SimpleOperatorTest );
  CPPUNIT_TEST ( CopyAtoms_withBondsOperatorTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void CopyAtomsInterfaceOperatorTest();
  void CopyAtoms_SimpleOperatorTest();
  void CopyAtoms_withBondsOperatorTest();

private:
  atom *atoms [ATOM_COUNT];
  atomId_t atomIds [ATOM_COUNT];
};

#endif /* COPYATOMSINTERFACEUNITTEST_HPP_ */
