/*
 * CopyAtoms_withBonds.hpp
 *
 *  Created on: Mar 17, 2012
 *      Author: heber
 */

#ifndef COPYATOMS_WITHBONDS_HPP_
#define COPYATOMS_WITHBONDS_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "Atom/CopyAtoms/CopyAtoms_Simple.hpp"
#include "CodePatterns/Assert.hpp"

class atom;

/** This is an extented implementation of CopyAtoms_Simple that also copies the bonds.
 *
 */
class CopyAtoms_withBonds : public CopyAtoms_Simple
{
public:
  /** Destructor.
   *
   */
  virtual ~CopyAtoms_withBonds()
  {}

  /** In this function we add to the copied atoms also the bonds.
   *
   * @param _atoms atoms to copy
   */
  virtual void operator()(const AtomVector &_atoms);

private:
  //!> type for lookup up man from original atoms to copied ones.
  typedef std::map< const atom *,  atom *> LookupMap_t;

  /** Internal helper to create a lookup map from original atoms to copies.
   *
   * This fills LookupMap.
   *
   * @param _atoms vector with original atoms
   */
  LookupMap_t createLookup(const AtomVector &_atoms)
  {
    LookupMap_t LookupMap;
    AtomVector::const_iterator original_iter = _atoms.begin();
    AtomVector::iterator copy_iter = CopiedAtoms.begin();
    for (; original_iter != _atoms.end(); ++original_iter, ++copy_iter) {
      ASSERT( copy_iter != CopiedAtoms.end(),
          "CopyAtoms_withBonds::createLookup() - the number of copied atoms is insufficient.");
  #ifndef NDEBUG
      std::pair< LookupMap_t::iterator, bool> inserter =
  #endif
      LookupMap.insert( std::make_pair( *original_iter, *copy_iter ) );
      ASSERT( (inserter.second) || (inserter.first->second == *copy_iter),
          "CopyAtoms_withBonds::createLookup() - There is twice the same original atom for two distinct copies.");
    }
    ASSERT( copy_iter == CopiedAtoms.end(),
        "CopyAtoms_withBonds::createLookup() - the number of copied atoms exceeds number of original ones.");
    return LookupMap;
  }
};


#endif /* COPYATOMS_WITHBONDS_HPP_ */
