/*
 * CopyAtoms_Simple.hpp
 *
 *  Created on: Mar 17, 2012
 *      Author: heber
 */

#ifndef COPYATOMS_SIMPLE_HPP_
#define COPYATOMS_SIMPLE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <algorithm>
#include <boost/bind.hpp>

#include "Atom/atom.hpp"
#include "Atom/CopyAtoms/CopyAtomsInterface.hpp"

/** This is an implementation of CopyAtomsInterface that simply copies each atom.
 *
 */
class CopyAtoms_Simple : public CopyAtomsInterface
{
public:
  /** Destructor.
   *
   */
  virtual ~CopyAtoms_Simple()
  {}

  /** This operator simply copies all the atoms in \a CopyAtomsInterface::atoms and
   * translates them to the same position.
   *
   * @param _atoms atoms to copy
   */
  virtual void operator()(const AtomVector &_atoms)
  {
    CopyAtomsInterface::operator()(_atoms);

    // copy each atom
    std::transform(_atoms.begin(), _atoms.end(), CopiedAtoms.begin(),
        boost::bind(&atom::clone, _1) );
  }
};


#endif /* COPYATOMS_SIMPLE_HPP_ */
