/*
 * CopyAtoms_SaturateDanglingBonds.hpp
 *
 *  Created on: Mar 17, 2012
 *      Author: heber
 */

#ifndef COPYATOMS_SATURATEDANGLINGBONDS_HPP_
#define COPYATOMS_SATURATEDANGLINGBONDS_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Atom/CopyAtoms/CopyAtomsInterface.hpp"

/** This class extends the implementation of CopyAtoms_withBonds to not only
 * copy the atoms and their bonds but also to saturate any dangling ones with
 * additional hydrogen atoms.
 *
 */
template <class BondCopier>
class CopyAtoms_SaturateDanglingBonds : public BondCopier, virtual public CopyAtomsInterface
{
public:
  /** Destructor.
   *
   */
  virtual ~CopyAtoms_SaturateDanglingBonds()
  {}

  /** Function to saturate any dangling bonds with additional hydrogen.
   *
   * @param _atoms vector of atoms to copy
   */
  virtual void operator()(const AtomVector &_atoms);
};



#endif /* COPYATOMS_SATURATEDANGLINGBONDS_HPP_ */
