/*
 * CopyAtomsInterface.hpp
 *
 *  Created on: Mar 17, 2012
 *      Author: heber
 */

#ifndef COPYATOMSINTERFACE_HPP_
#define COPYATOMSINTERFACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

class atom;
class CopyAtomsInterfaceTest;

/** This class defines a general interface for functors that copy a Vector of Atoms.
 *
 * I.e. we can implement here multiple ways of copying a vector of atoms, with or
 * without bonds, with or without saturation, ...
 *
 */
class CopyAtomsInterface
{
  /// grant unit test access
  friend class CopyAtomsInterfaceTest;
public:
  typedef std::vector<atom*> AtomVector;
  typedef std::vector<const atom*> ConstAtomVector;

  /** Constructor.
   *
   */
  CopyAtomsInterface()
  {}

  /** Destructor.
   *
   */
  virtual ~CopyAtomsInterface()
  {}

  /** Function that just stores given atoms in CopyAtomsInterface::OriginalAtoms.
   *
   * We reset ourselves.
   * We initialize CopyAtomsInterface::CopiedAtoms with the size of \a _atoms
   * but NULL entities.
   *
   * \note If you override this function, always first call the implementation
   * in the original class, then continue with implementation in derived class.
   *
   * @param _atoms atoms to copy
   */
  virtual void operator()(const AtomVector &_atoms)
  {
    // clear ourselves
    reset();
    CopiedAtoms.resize(_atoms.size(), NULL);
  }

  /** Getter for CopiedAtoms to allow outside transformations.
   *
   * @return CopiedAtoms
   */
  AtomVector& getCopiedAtoms() {
    return CopiedAtoms;
  }

private:
  /// forbid copy cstor as it may change class behavior
  CopyAtomsInterface(const CopyAtomsInterface &);

  /** Internal helper to reset all member variables.
   *
   */
  void reset()
  {
    CopiedAtoms.clear();
  }

protected:
  //!> set of copied atoms, this is to allow later transformations in derived classes
  AtomVector CopiedAtoms;
};

#endif /* COPYATOMSINTERFACE_HPP_ */
