/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllAtomsInsideSphereAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Descriptors/AtomShapeDescriptor.hpp"
#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"
#include "Shapes/ShapeOps.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "NotAllAtomsInsideSphereAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAllAtomsInsideSphereAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  LOG(1, "Unselecting all atoms inside a sphere at " << params.position << " with radius " << params.radius << ".");
  Shape s = translate(resize(Sphere(),params.radius),params.position);
  std::vector<atom *> unselectedAtoms = World::getInstance().getAllAtoms((!AtomsBySelection()) && AtomsByShape(s));
  World::getInstance().unselectAllAtoms(AtomsByShape(s));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms remain selected.");
  return Action::state_ptr(new SelectionNotAllAtomsInsideSphereState(unselectedAtoms, s, params));
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsInsideSphereState *state = assert_cast<SelectionNotAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomsByShape(state->s));
  BOOST_FOREACH(atom *_atom, state->unselectedAtoms)
    World::getInstance().unselectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllAtomsInsideSphereAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsInsideSphereState *state = assert_cast<SelectionNotAllAtomsInsideSphereState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomsByShape(state->s));

  return Action::state_ptr(_state);
}

bool SelectionNotAllAtomsInsideSphereAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsInsideSphereAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
