/*
 * QtQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef QTQUERY_HPP_
#define QTQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <Qt/qwidget.h>
#include "Qt4/QtDialog.hpp"
#include "Parameters/Parameter.hpp"
#include "QtQueryList.hpp"

class QHBoxLayout;
class QBoxLayout;
class QDialogButtonBox;
class QLabel;
class QSpinBox;
class QDoubleSpinBox;
class QLineEdit;
class QListWidget;
class QPushButton;
class QTableWidget;
class QTextEdit;
class QComboBox;
class QCheckBox;
class QFileDialog;

class QtDialog::AtomQtQuery : public QWidget, public Dialog::AtomQuery {
  Q_OBJECT
public:
  AtomQtQuery(Parameter<const atom *> &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~AtomQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::AtomsQtQuery : public QWidget, public Dialog::AtomsQuery {
  Q_OBJECT
public:
  AtomsQtQuery(Parameter<std::vector<const atom *> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~AtomsQtQuery();
  virtual bool handle();

public slots:
  void onUpdate();

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLabel *inputLabel;
  QListWidget *inputList;
  Dialog *dialog;
};

class QtDialog::BooleanQtQuery : public QWidget, public Dialog::BooleanQuery {
  Q_OBJECT
public:
  BooleanQtQuery(Parameter<bool> &, std::string _title, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~BooleanQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QCheckBox *booleanCheckBox;
  Dialog *dialog;
};

class QtDialog::RealSpaceMatrixQtQuery : public QWidget, public Dialog::RealSpaceMatrixQuery {
  Q_OBJECT
public:
  RealSpaceMatrixQtQuery(Parameter<RealSpaceMatrix> &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~RealSpaceMatrixQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int, int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QTableWidget *inputTable;
  Dialog *dialog;
};

class QtDialog::DoubleQtQuery : public QWidget, public Dialog::DoubleQuery {
  Q_OBJECT
public:
  DoubleQtQuery(Parameter<double> &, std::string title,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~DoubleQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(double);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QDoubleSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::DoublesQtQuery : public QWidget, public Dialog::DoublesQuery {
  Q_OBJECT
public:
  DoublesQtQuery(Parameter<std::vector<double> > &, std::string title,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~DoublesQtQuery();
  virtual bool handle();

public slots:
  void onUpdate();

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QDoubleSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::ElementQtQuery : public QWidget, public Dialog::ElementQuery {
  Q_OBJECT
public:
  ElementQtQuery(Parameter<const element *> &, std::string _title, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~ElementQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::ElementsQtQuery : public QWidget, public Dialog::ElementsQuery, public QtQueryList<const element *> {
  Q_OBJECT
public:
  ElementsQtQuery(Parameter<std::vector<const element *> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~ElementsQtQuery();
  virtual bool handle();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  ElementQtQuery *subQuery;
};

class QtDialog::EmptyQtQuery : public Dialog::EmptyQuery {
public:
  EmptyQtQuery(std::string _title, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~EmptyQtQuery();
  virtual bool handle();
private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  Dialog *dialog;
};

class QtDialog::FileQtQuery : public QWidget, public Dialog::FileQuery {
  Q_OBJECT
public:
  FileQtQuery(Parameter<boost::filesystem::path> &, std::string _title, QBoxLayout *_parent, Dialog *_dialog);
  virtual ~FileQtQuery();
  virtual bool handle();

public slots:
  void onUpdate();
  void showFileDialog();

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *filenameLabel;
  QLineEdit *filenameLineEdit;
  QPushButton *filedialogButton;
  QFileDialog *theFileDialog;
  Dialog *dialog;
};

class QtDialog::FilesQtQuery : public QWidget, public Dialog::FilesQuery, public QtQueryList<boost::filesystem::path> {
  Q_OBJECT
public:
  FilesQtQuery(Parameter<std::vector<boost::filesystem::path> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~FilesQtQuery();
  virtual bool handle();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  FileQtQuery *subQuery;
};

class QtDialog::IntQtQuery : public QWidget, public Dialog::IntQuery {
  Q_OBJECT
public:
  IntQtQuery(Parameter<int> &, std::string _title,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~IntQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::IntsQtQuery : public QWidget, public Dialog::IntsQuery, public QtQueryList<int> {
  Q_OBJECT
public:
  IntsQtQuery(Parameter<std::vector<int> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~IntsQtQuery();
  virtual bool handle();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  IntQtQuery *subQuery;
};

class QtDialog::MoleculeQtQuery : public QWidget, public Dialog::MoleculeQuery {
  Q_OBJECT
public:
  MoleculeQtQuery(Parameter<const molecule *> &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~MoleculeQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::MoleculesQtQuery : public QWidget, public Dialog::MoleculesQuery {
  Q_OBJECT
public:
  MoleculesQtQuery(Parameter<std::vector<const molecule *> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~MoleculesQtQuery();
  virtual bool handle();

public slots:
  void onUpdate();

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QComboBox *inputBox;
  Dialog *dialog;
};

class QtDialog::StringQtQuery : public QWidget, public Dialog::StringQuery {
  Q_OBJECT
public:
  StringQtQuery(Parameter<std::string> &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~StringQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(const QString&);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QLineEdit *inputBox;
  Dialog *dialog;
};

class QtDialog::StringsQtQuery : public QWidget, public Dialog::StringsQuery, public QtQueryList<std::string> {
  Q_OBJECT
public:
  StringsQtQuery(Parameter<std::vector<std::string> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~StringsQtQuery();
  virtual bool handle();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  StringQtQuery *subQuery;
};

class QtDialog::UnsignedIntQtQuery : public QWidget, public Dialog::UnsignedIntQuery {
  Q_OBJECT
public:
  UnsignedIntQtQuery(Parameter<unsigned int> &, std::string _title,QBoxLayout *_parent,Dialog *_dialog);
  virtual ~UnsignedIntQtQuery();
  virtual bool handle();

public slots:
  void onUpdate(int);

private:
  QBoxLayout *parent;
  QBoxLayout *thisLayout;
  QLabel *titleLabel;
  QSpinBox *inputBox;
  Dialog *dialog;
};

class QtDialog::UnsignedIntsQtQuery : public QWidget, public Dialog::UnsignedIntsQuery, public QtQueryList<unsigned int> {
  Q_OBJECT
public:
  UnsignedIntsQtQuery(Parameter<std::vector<unsigned int> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~UnsignedIntsQtQuery();
  virtual bool handle();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  UnsignedIntQtQuery *subQuery;
};

class QtDialog::VectorQtQuery : public QWidget, public Dialog::VectorQuery {
  Q_OBJECT
public:
  VectorQtQuery(Parameter<Vector> &, std::string title,QBoxLayout *,Dialog *);
  virtual ~VectorQtQuery();
  virtual bool handle();

public slots:
  void onUpdateX(double);
  void onUpdateY(double);
  void onUpdateZ(double);

private:
  QBoxLayout *parent;
  QBoxLayout *mainLayout;
  QLabel *titleLabel;
  QBoxLayout *subLayout;
  QBoxLayout *coordLayout;
  QLabel *coordLabel;
  QDoubleSpinBox *coordInputX;
  QDoubleSpinBox *coordInputY;
  QDoubleSpinBox *coordInputZ;
  Dialog *dialog;
};

class QtDialog::VectorsQtQuery : public QWidget, public Dialog::VectorsQuery, public QtQueryList<Vector> {
  Q_OBJECT
public:
  VectorsQtQuery(Parameter<std::vector<Vector> > &, std::string _title, QBoxLayout *_parent,Dialog *_dialog);
  virtual ~VectorsQtQuery();
  virtual bool handle();

  virtual void onSubUpdate();

public slots:
  void onAddElement();
  void onRemoveElement();
  void onElementSelected();

private:
  VectorQtQuery *subQuery;
};

class QtDialog::RandomNumberDistribution_ParametersQtQuery : public QWidget, public Dialog::RandomNumberDistribution_ParametersQuery {
  Q_OBJECT
public:
  RandomNumberDistribution_ParametersQtQuery(Parameter<RandomNumberDistribution_Parameters> &, std::string title,QBoxLayout *,Dialog *);
  virtual ~RandomNumberDistribution_ParametersQtQuery();
  virtual bool handle();

public slots:
  void onUpdate();

private:
  QBoxLayout *parent;
  QHBoxLayout *thisLayout;
  QLabel *titleLabel;
  QTextEdit *inputBox;
  QPushButton *okButton;
  Dialog *dialog;
};

#endif /* QTQUERY_HPP_ */
