/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * BoundInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/shared_ptr.hpp>

#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>
#include <vector>

#include "Actions/MoleculeAction/BoundInBoxAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "BoundInBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeBoundInBoxAction::performCall() {
  // create undo state
  std::vector< boost::shared_ptr<Vector> > OldPositions;
  {
    std::vector<const molecule*> SelectedMolecules = const_cast<const World &>(World::getInstance()).
        getSelectedMolecules();
    for (vector<const molecule*>::iterator MolRunner = SelectedMolecules.begin();
        MolRunner != SelectedMolecules.end();
        ++MolRunner) {
      for(molecule::const_iterator AtomRunner = (*MolRunner)->begin();
          AtomRunner != (*MolRunner)->end();
          ++AtomRunner) {
        OldPositions.push_back(
            boost::shared_ptr<Vector>(new Vector(
                (*AtomRunner)->getPosition()
                ))
            );
      }
    }
  }
  MoleculeBoundInBoxState *undoState = new MoleculeBoundInBoxState(OldPositions, params);

  // center
  std::vector<molecule*> SelectedMolecules = World::getInstance().getSelectedMolecules();
  for (std::vector<molecule*>::iterator MolRunner = SelectedMolecules.begin(); MolRunner != SelectedMolecules.end(); ++MolRunner) {
    (*MolRunner)->BoundInBox();
  }
  return ActionState::ptr(undoState);
}

ActionState::ptr MoleculeBoundInBoxAction::performUndo(ActionState::ptr _state) {
  MoleculeBoundInBoxState *state = assert_cast<MoleculeBoundInBoxState*>(_state.get());

  // place atoms on old positions
  std::vector< boost::shared_ptr<Vector> >::const_iterator OldPositionsIter = state->OldPositions.begin();
  std::vector<molecule*> SelectedMolecules = World::getInstance().getSelectedMolecules();
  for (std::vector<molecule*>::iterator MolRunner = SelectedMolecules.begin();
      MolRunner != SelectedMolecules.end();
      ++MolRunner) {
    for(molecule::iterator AtomRunner = (*MolRunner)->begin();
        AtomRunner != (*MolRunner)->end();
        ++AtomRunner) {
      ASSERT(OldPositionsIter != state->OldPositions.end(),
          "MoleculeBoundInBoxAction::performUndo() - too few positions stored in UndoState.");
      (*AtomRunner)->setPosition(**(OldPositionsIter++));
    }
  }

  return ActionState::ptr(_state);
}

ActionState::ptr MoleculeBoundInBoxAction::performRedo(ActionState::ptr _state){
//  MoleculeBoundInBoxState *state = assert_cast<MoleculeBoundInBoxState*>(_state.get());

  // center
  std::vector<molecule*> SelectedMolecules = World::getInstance().getSelectedMolecules();
  for (std::vector<molecule*>::iterator MolRunner = SelectedMolecules.begin();
      MolRunner != SelectedMolecules.end();
      ++MolRunner) {
    (*MolRunner)->BoundInBox();
  }

  return ActionState::ptr(_state);
}

bool MoleculeBoundInBoxAction::canUndo() {
  return true;
}

bool MoleculeBoundInBoxAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
