/*
 * StreamStringView.hpp
 *
 *  Created on: Dec 14, 2009
 *      Author: crueger
 */

#ifndef STREAMSTRINGVIEW_HPP_
#define STREAMSTRINGVIEW_HPP_

#include <boost/function.hpp>
#include <iostream>

#include "Views/StringView.hpp"

/**
 * Wrapper to produce a StringView from any method that uses a stream to display something.
 *
 * The function is called with a stringstream which then is turned into a string later.
 *
 * Caveat: Make sure the stream passed to the method is actually used. Some methods seem to use a stream parameter for
 * legacy reasons. These methods internally use the "Log() << Verbose()" mechanism instead of the stream.
 */
class StreamStringView : public StringView
{
public:
  StreamStringView(boost::function<void(std::ostream *)>);
  virtual ~StreamStringView();

  virtual const std::string toString();

private:
  boost::function<void(std::ostream *)> displayMethod;
};

#endif /* STREAMSTRINGVIEW_HPP_ */
