/*
 * Fragmentation.hpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

#ifndef FRAGMENTATION_HPP_
#define FRAGMENTATION_HPP_


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "graph.hpp"
#include "Graph/DepthFirstSearchAnalysis.hpp"

class atom;
class molecule;

class Fragmentation
{
public:
  Fragmentation(molecule *_mol);
  ~Fragmentation();

  int FragmentMolecule(int Order, std::string &prefix, DepthFirstSearchAnalysis &DFS);

private:

  void FragmentBOSSANOVA(molecule *mol, Graph *&FragmentList, KeyStack &RootStack);
  int GuesstimateFragmentCount(int order);

  bool CreateMappingLabelsToConfigSequence(int *&SortIndex);

  // order at site
  bool CheckOrderAtSite(bool *AtomMask, Graph *GlobalKeySetList, int Order, std::string path);
  bool StoreOrderAtSiteFile(std::string &path);
  bool ParseOrderAtSiteFromFile(std::string &path);

  // storing fragments
  molecule * StoreFragmentFromKeySet(KeySet &Leaflet, bool IsAngstroem);
  int StoreFragmentFromKeySet_Init(molecule *mol, molecule *Leaf, KeySet &Leaflet, atom **SonList);
  void CreateInducedSubgraphOfFragment(molecule *mol, molecule *Leaf, atom **SonList, bool IsAngstroem);

private:
  molecule *mol;
};


#endif /* FRAGMENTATION_HPP_ */
