/*
 * STLVectorValidator.hpp
 *
 *  Created on: May 9, 2012
 *      Author: heber
 */

#ifndef VECTORVALIDATOR_HPP_
#define VECTORVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DummyValidator.hpp"
#include "RangeValidator.hpp"
#include "Validator.hpp"

#include <vector>

#include "CodePatterns/Range.hpp"

/** This validator checks whether a given class which must be a (STL) container
 *  with value_type typedef has only unique items.
 */
template <class T>
class UniqueValidator : public Validator< T >
{
  //!> this should throw an error at compile time if T is not a container
  typedef typename T::value_type valuetype;

public:
  /** Constructor for class UniqueValidator.
   *
   */
  UniqueValidator()
  {}

  /** Destructor for class UniqueValidator
   *
   */
  ~UniqueValidator()
  {}

  bool isValid(const T & _value) const
  {
    // make unique and check length
    T copyvalue(_value);
    std::sort(copyvalue.begin(), copyvalue.end());
    typename T::const_iterator iter = std::unique(copyvalue.begin(), copyvalue.end());
    if (iter == copyvalue.end())
      return true;
    else
      return false;
  }
  bool operator==(const Validator<T> &_instance) const
  {
    const UniqueValidator<T> *inst = dynamic_cast<const UniqueValidator<T> *>(&_instance);
    if (inst)
      return true;
    else
      return false;
  }

  Validator<T>* clone() const
  {
    Validator<T> *inst = new UniqueValidator<T>();
    return inst;
  }
};


#endif /* VECTORVALIDATOR_HPP_ */
