/*
 * InterfaceVMGDebugGridJob.hpp
 *
 *  Created on: 31.08.2012
 *      Author: Frederik Heber
 */

#ifndef INTERFACEVMGDEBUGGRIDJOB_HPP_
#define INTERFACEVMGDEBUGGRIDJOB_HPP_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "base/interface.hpp"
#include "base/vector.hpp"

namespace VMG
{
class Grid;
class Multigrid;
}

namespace VMGInterfaces
{

/** This interface is only used to get the \a sampled_input into the VMG
 *  grid to make use of its vtk displayer for debugging purposes.
 *
 *  See VMGDebugGridJob.
 */
class InterfaceVMGDebugGridJob : public VMG::Interface
{
public:
  InterfaceVMGDebugGridJob(
      const std::vector< double > &_sampled_input,
      VMG::Boundary boundary,
      int levelMin,
      int levelMax,
      const VMG::Vector &box_begin,
      vmg_float box_end,
      const int& near_field_cells,
      int coarseningSteps=0,
      double alpha=1.6);

  virtual ~InterfaceVMGDebugGridJob();

  void ImportRightHandSide(VMG::Multigrid& multigrid);
  void ExportSolution(VMG::Grid& grid);

private:
  //!> sampled density on the grid as input
  const std::vector< double > sampled_input;
  //!> number of grid points per axis as \f$2^{\text{level}}\f$
  const int level;
};

}

#endif /* INTERFACEVMGDEBUGGRIDJOB_HPP_ */
