/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SuspendInWaterAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "boundary.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/MoleculeAction/SuspendInWaterAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SuspendInWaterAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeSuspendInWaterAction::performCall() {
  molecule *mol = NULL;
  double volume = 0.;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating necessary cell volume for a cluster suspended in water.");
    if (params.density < 1.0) {
      DoeLog(1) && (eLog()<< Verbose(1) << "Density must be greater than 1.0g/cm^3!" << endl);
    } else {
      PrepareClustersinWater(World::getInstance().getConfig(), mol, volume, params.density);  // if volume == 0, will calculate from ConvexEnvelope
    }
  }
  return Action::success;
}

Action::state_ptr MoleculeSuspendInWaterAction::performUndo(Action::state_ptr _state) {
//  MoleculeSuspendInWaterState *state = assert_cast<MoleculeSuspendInWaterState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSuspendInWaterAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSuspendInWaterAction::canUndo() {
  return false;
}

bool MoleculeSuspendInWaterAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
