/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ChangeNameAction.cpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "molecule.hpp"

#include <iostream>
#include <string>

#include "Actions/MoleculeAction/ChangeNameAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ChangeNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeChangeNameAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  if (World::getInstance().countSelectedMolecules() == 1) {
    mol = World::getInstance().beginMoleculeSelection()->second;
    string oldName = mol->getName();
    mol->setName(params.name);
    return Action::state_ptr(new MoleculeChangeNameState(mol,params));
  } else
    return Action::failure;
}

Action::state_ptr MoleculeChangeNameAction::performUndo(Action::state_ptr _state) {
  MoleculeChangeNameState *state = assert_cast<MoleculeChangeNameState*>(_state.get());

  string newName = state->mol->getName();
  state->mol->setName(state->params.name);
  state->params.name = newName;

  return Action::state_ptr(_state);
}

Action::state_ptr MoleculeChangeNameAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeChangeNameAction::canUndo() {
  return true;
}

bool MoleculeChangeNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
