/*
 * SelectiveIterator_impl.hpp
 *
 *  Created on: Mar 17, 2010
 *      Author: crueger
 */

#ifndef SELECTIVEITERATOR_IMPL_HPP_
#define SELECTIVEITERATOR_IMPL_HPP_

#include "helpers.hpp"

template<class _Target,
         class _Container,
         class _Descriptor>
SelectiveIterator<_Target,_Container,_Descriptor>::SelectiveIterator(_Descriptor _descr, _Container &_content) :
    descr(_descr.get_impl()),
    index(0),
    content(_content)
{
  state = content.begin();
  advanceState();
}

template<class _Target,
         class _Container,
         class _Descriptor>
SelectiveIterator<_Target,_Container,_Descriptor>::SelectiveIterator(_Descriptor _descr, _Container &_content, SelectiveIterator<_Target,_Container,_Descriptor>::Iter _state) :
    state(_state),
    descr(_descr.get_impl()),
    index(0),
    content(_content)
{
  advanceState();
}

template<class _Target,
         class _Container,
         class _Descriptor>
SelectiveIterator<_Target,_Container,_Descriptor>::SelectiveIterator(const SelectiveIterator<_Target,_Container,_Descriptor>& rhs) :
    state(rhs.state),
    descr(rhs.descr),
    index(rhs.index),
    content(rhs.content)
  {}

template<class _Target,
         class _Container,
         class _Descriptor>
SelectiveIterator<_Target,_Container,_Descriptor>& SelectiveIterator<_Target,_Container,_Descriptor>::operator=(const SelectiveIterator<_Target,_Container,_Descriptor>& rhs)
{
  if(&rhs!=this){
    state=rhs.state;
    descr=rhs.descr;
    index=rhs.index;
  }
  return *this;
}

template<class _Target,
         class _Container,
         class _Descriptor>
SelectiveIterator<_Target,_Container,_Descriptor>&
  SelectiveIterator<_Target,_Container,_Descriptor>::operator++(){
    ++state;
    ++index;
    advanceState();
    return *this;
  }

template<class _Target,
         class _Container,
         class _Descriptor>
SelectiveIterator<_Target,_Container,_Descriptor> SelectiveIterator<_Target,_Container,_Descriptor>::operator++(int){
    SelectiveIterator<_Target,_Container,_Descriptor> res = SelectiveIterator<_Target,_Container,_Descriptor>(*this);
    ++(*this);
    return res;
  }

template<class _Target,
         class _Container,
         class _Descriptor>
bool
  SelectiveIterator<_Target,_Container,_Descriptor>::operator==(const SelectiveIterator<_Target,_Container,_Descriptor>& rhs){
    return state==rhs.state;
  }

template<class _Target,
         class _Container,
         class _Descriptor>
bool
  SelectiveIterator<_Target,_Container,_Descriptor>::operator!=(const SelectiveIterator<_Target,_Container,_Descriptor>& rhs){
    return state!=rhs.state;
  }

template<class _Target,
         class _Container,
         class _Descriptor>
typename SelectiveIterator<_Target,_Container,_Descriptor>::Target
  SelectiveIterator<_Target,_Container,_Descriptor>::operator*(){
    return _take<_Target,value_type>::get(*state);
  }

template<class _Target,
         class _Container,
         class _Descriptor>
void
  SelectiveIterator<_Target,_Container,_Descriptor>::advanceState(){
    // go forward until we have a matching atom or the end is reached
    while((state!=content.end()) && (!descr->predicate(*state))){
      ++state;
      ++index;
    }
  }

template<class _Target,
         class _Container,
         class _Descriptor>
int
  SelectiveIterator<_Target,_Container,_Descriptor>::getCount(){
    return index;
  }


#define CONSTRUCT_SELECTIVE_ITERATOR(_Target,_Container,_Descriptor) \
		template SelectiveIterator<_Target,_Container,_Descriptor>::SelectiveIterator(_Descriptor, _Container&); \
		template SelectiveIterator<_Target,_Container,_Descriptor>::SelectiveIterator(_Descriptor, _Container&, SelectiveIterator<_Target,_Container,_Descriptor>::Iter); \
    template SelectiveIterator<_Target,_Container,_Descriptor>::SelectiveIterator(const SelectiveIterator<_Target,_Container,_Descriptor>&); \
    template SelectiveIterator<_Target,_Container,_Descriptor>& SelectiveIterator<_Target,_Container,_Descriptor>::operator=(const SelectiveIterator<_Target,_Container,_Descriptor>&); \
    template SelectiveIterator<_Target,_Container,_Descriptor>& SelectiveIterator<_Target,_Container,_Descriptor>::operator++(); \
    template SelectiveIterator<_Target,_Container,_Descriptor> SelectiveIterator<_Target,_Container,_Descriptor>::operator++(int); \
    template bool SelectiveIterator<_Target,_Container,_Descriptor>::operator==(const SelectiveIterator<_Target,_Container,_Descriptor>&); \
    template bool SelectiveIterator<_Target,_Container,_Descriptor>::operator!=(const SelectiveIterator<_Target,_Container,_Descriptor>&); \
    template SelectiveIterator<_Target,_Container,_Descriptor>::Target SelectiveIterator<_Target,_Container,_Descriptor>::operator*(); \
    template int SelectiveIterator<_Target,_Container,_Descriptor>::getCount();

#endif /* SELECTIVEITERATOR_IMPL_HPP_ */
