/*
 * SelectiveIterator.hpp
 *
 *  Created on: Mar 17, 2010
 *      Author: crueger
 */

#ifndef SELECTIVEITERATOR_HPP_
#define SELECTIVEITERATOR_HPP_

#include <iterator>

template<class _Target,
         class _Container,
         class _Descriptor>
class SelectiveIterator :
  public std::iterator<typename std::iterator_traits<typename _Container::iterator>::difference_type,
                       typename std::iterator_traits<typename _Container::iterator>::value_type,
                       typename std::iterator_traits<typename _Container::iterator>::pointer,
                       typename std::iterator_traits<typename _Container::iterator>::reference>
{
public:
  typedef typename _Container::iterator     Iter;
  typedef          _Target                  Target;
  typedef typename Iter::value_type         value_type;
  typedef typename Iter::difference_type    difference_type;
  typedef typename Iter::pointer            pointer;
  typedef typename Iter::reference          reference;
  typedef typename Iter::iterator_category  iterator_category;


  SelectiveIterator(_Descriptor, _Container&);
  SelectiveIterator(_Descriptor, _Container&, Iter);
  SelectiveIterator(const SelectiveIterator&);
  SelectiveIterator& operator=(const SelectiveIterator&);
  SelectiveIterator& operator++();     // prefix
  SelectiveIterator  operator++(int);  // postfix with dummy parameter
  bool operator==(const SelectiveIterator&);
  bool operator!=(const SelectiveIterator&);
  Target operator*();

  int getCount();
protected:
  void advanceState();
  Iter state;
  typename _Descriptor::impl_ptr descr;
  int index;

  _Container &content;
};

#endif /* SELECTIVEITERATOR_HPP_ */
