/*
 * DescriptorBase_impl.hpp
 *
 *  Created on: Mar 12, 2010
 *      Author: crueger
 */

#ifndef DESCRIPTORBASE_IMPL_HPP_
#define DESCRIPTORBASE_IMPL_HPP_

#include "Descriptors/DescriptorBase.hpp"
#include <utility>
#include <boost/bind.hpp>

template<class _Target,
         class _Container>
class DescriptorBase_impl{
public:
  typedef _Target Target;
  typedef std::vector<Target> TargetVec;
  typedef _Container Container;
  typedef typename Container::value_type value_type;
  typedef typename Container::iterator iterator;

  DescriptorBase_impl();
  ~DescriptorBase_impl();

  virtual bool predicate(value_type)=0;

  virtual Target    find(Container&);
  virtual TargetVec findAll(Container&);
protected:
  const _take<Target,value_type> take;
};

template<class _Target,
         class _Container>
DescriptorBase_impl<_Target,_Container>::DescriptorBase_impl(){}

template<class _Target,
         class _Container>
DescriptorBase_impl<_Target,_Container>::~DescriptorBase_impl(){}

template<class _Target,
         class _Container>
typename DescriptorBase_impl<_Target,_Container>::Target
  DescriptorBase_impl<_Target,_Container>::find(DescriptorBase_impl<_Target,_Container>::Container& container){
    iterator res = find_if(container.begin(),
                           container.end(),
                           boost::bind(&DescriptorBase_impl<_Target,_Container>::predicate,this,_1));
    return (res!=container.end())?(take(*res)):0;
  }

template<class _Target,
         class _Container>
typename DescriptorBase_impl<_Target,_Container>::TargetVec
  DescriptorBase_impl<_Target,_Container>::findAll(DescriptorBase_impl<_Target,_Container>::Container& container) {
  TargetVec res;
  iterator iter;
  for(iter=container.begin();iter!=container.end();++iter) {
    if(predicate(*iter)){
      res.push_back(take(*iter));
    }
  }
  return res;
}

#endif /* DESCRIPTORBASE_IMPL_HPP_ */
