/*
 * DescriptorBase.hpp
 *
 *  Created on: Mar 12, 2010
 *      Author: crueger
 */

#ifndef DESCRIPTORBASE_HPP_
#define DESCRIPTORBASE_HPP_

#include <vector>
#include <boost/shared_ptr.hpp>

/***
 * Code in this file is not used.
 *
 * I was not able to figure out how to factor out the common code for
 * descriptors and have given up :-( . If somebody else wants to have
 * another shot just go ahead, but expect a hard ride from here on.
 */

template<class _Target,
         class _Container>
class DescriptorBase_impl;


template<class _Target,
         class _Container>
class SelectiveIterator;

template<class _Target,
         class _Container>
class DescriptorBase
{
  friend class DescriptorBase_impl<_Target,_Container>;
  friend class SelectiveIterator<_Target,_Container>;


  // expose the type of this descriptor to the public
public:
  typedef _Target     Target;
  typedef std::vector<Target> TargetVec;

protected:
  typedef _Container  Container;
  typedef typename Container::iterator iterator;

  typedef DescriptorBase_impl<Target,Container>  impl;
  typedef boost::shared_ptr<impl> impl_ptr;


public:

  DescriptorBase();
  DescriptorBase(const DescriptorBase&);
  DescriptorBase(impl_ptr);
  virtual ~DescriptorBase();

  DescriptorBase& operator=(const DescriptorBase&);

  /**
   * forward Method to implementation
   */
  Target find(Container&);

  /**
   * forward Method to implementation
   */
  TargetVec findAll(Container&);


private:
  impl_ptr theImpl;
};

template<class _Target,
         class _Container>
DescriptorBase<_Target,_Container> AllX();

template<class _Target,
         class _Container>
DescriptorBase<_Target,_Container> NoX();

template<class _Target,
         class _Container>
DescriptorBase<_Target,_Container>
  operator&&(DescriptorBase<_Target,_Container>&,
             DescriptorBase<_Target,_Container>&);

template<class _Target,
         class _Container>
DescriptorBase<_Target,_Container>
  operator||(DescriptorBase<_Target,_Container>&,
             DescriptorBase<_Target,_Container>&);

template<class _Target,
         class _Container>
DescriptorBase<_Target,_Container>
  operator!(DescriptorBase<_Target,_Container>&);

#endif /* DESCRIPTORBASE_HPP_ */
