/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtShapeController.cpp
 *
 *  Created on: Oct 25, 2012
 *      Author: ankele
 */



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/Qt4/QtShapeController.hpp"
#include "Views/Qt4/QtShapeList.hpp"
#include "Menu/Qt4/QtMenuPipe.hpp"

#include <iostream>

#include<Qt/qlayout.h>
#include<Qt/qpushbutton.h>
#include<Qt/qlabel.h>
#include <Qt/qaction.h>
#include <Qt/qmenu.h>

#include "CodePatterns/MemDebug.hpp"

using namespace std;

QtShapeController::QtShapeController(QWidget * _parent) :
    QWidget (_parent)
{
  // Create the widgets.
  QLabel *label = new QLabel("Shapes");
  QtShapeList *shapeList = new QtShapeList;
  QPushButton *createButton = new QPushButton(QIcon(QIcon::fromTheme("edit-add")), "create");
  QPushButton *editButton = new QPushButton(QIcon(QIcon::fromTheme("edit")), "edit");
  QPushButton *deleteButton = new QPushButton(QIcon(QIcon::fromTheme("edit-delete")), "delete");

  // Create layout.
  QVBoxLayout *shapeBox = new QVBoxLayout;
  shapeBox->setMargin(0);
  QHBoxLayout *buttonBox = new QHBoxLayout;
  buttonBox->addWidget(createButton);
  buttonBox->addWidget(editButton);
  buttonBox->addWidget(deleteButton);
  setLayout(shapeBox);
  shapeBox->addWidget(label);
  shapeBox->addWidget(shapeList);
  shapeBox->addLayout(buttonBox);


  // Create/connect the actions.
  QAction *action = new QAction(QString("create shape"), createButton);
  QtMenuPipe *pipe = new QtMenuPipe("create-shape", action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
  QObject::connect(createButton, SIGNAL(clicked()),action,SIGNAL(triggered()));

  QMenu *editMenu = new QMenu();
  pipe = new QtMenuPipe("combine-shapes", action);
  action = new QAction(QIcon::fromTheme("zoom-best-fit"), tr("combine"), this);
  connect(action, SIGNAL(triggered()), pipe, SLOT(called()));
  editMenu->addAction(action);
  pipe = new QtMenuPipe("translate-shapes", action);
  action = new QAction(QIcon::fromTheme("zoom-best-fit"), tr("translate"), this);
  connect(action, SIGNAL(triggered()), pipe, SLOT(called()));
  editMenu->addAction(action);
  pipe = new QtMenuPipe("rotate-shapes", action);
  action = new QAction(QIcon::fromTheme("zoom-best-fit"), tr("rotate"), this);
  connect(action, SIGNAL(triggered()), pipe, SLOT(called()));
  editMenu->addAction(action);
  editButton->setMenu(editMenu);

  action = new QAction(QString("remove shapes"), deleteButton);
  pipe = new QtMenuPipe("remove-shape", action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
  QObject::connect(deleteButton, SIGNAL(clicked()),action,SIGNAL(triggered()));
}

QtShapeController::~QtShapeController()
{
  for(std::list<QtMenuPipe*>::iterator it=plumbing.begin(); it != plumbing.end(); it++)
    delete (*it);
}
